/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.netcdf.AbstractNetcdf;
import ucar.netcdf.NetcdfRemoteProxy;
import ucar.netcdf.NetcdfService;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;

public class RemoteNetcdf
extends AbstractNetcdf {
    private NetcdfRemoteProxy remote;

    public static NetcdfService getNetcdfService(String remoteHostName) throws RemoteException, NotBoundException, MalformedURLException {
        String svcName = "//" + remoteHostName + "/" + "NetcdfService";
        return (NetcdfService)Naming.lookup(svcName);
    }

    public RemoteNetcdf(NetcdfRemoteProxy remote) throws RemoteException {
        super(remote.getSchema(), false);
        this.remote = remote;
        try {
            super.initHashtable();
        }
        catch (InstantiationException ie) {
            throw new Error();
        }
        catch (IllegalAccessException iae) {
            throw new Error();
        }
        catch (InvocationTargetException ite) {
            throw (RuntimeException)ite.getTargetException();
        }
    }

    public RemoteNetcdf(String remoteHostName, String dataSetName) throws RemoteException, NotBoundException, MalformedURLException {
        this(RemoteNetcdf.getNetcdfService(remoteHostName).lookup(dataSetName));
    }

    public void close() throws RemoteException {
        this.remote.release();
    }

    protected Accessor ioFactory(ProtoVariable proto) throws InvocationTargetException {
        try {
            return this.remote.getAccessor(proto.getName());
        }
        catch (IOException ee) {
            throw new InvocationTargetException(ee);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("test Usage: RemoteNetcdf nc_name");
            System.exit(1);
        }
        String name = args[0];
        try {
            RemoteNetcdf rnc = new RemoteNetcdf("localhost", name);
            System.out.println(rnc);
            VariableIterator vi = rnc.iterator();
            while (vi.hasNext()) {
                Variable v = vi.next();
                System.out.print(v.getName() + "[0, ...]: ");
                MultiArray ma = v.copyout(new int[v.getRank()], v.getLengths());
                System.out.println(ma.get(new int[ma.getRank()]));
            }
            rnc.close();
        }
        catch (Exception ee) {
            System.out.println(ee);
            System.exit(1);
        }
        System.exit(0);
    }
}

