/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.oneloopdiv;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseTokenSimpleTensor;
import cc.redberry.core.parser.preprocessor.IndicesInsertion;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.TraverseState;
import cc.redberry.core.transformations.EliminateMetricsTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.Transformer;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.Indicator;
import cc.redberry.physics.oneloopdiv.SqrSubs;
import java.util.Arrays;

public final class OneLoopInput {
    private final Expression[] inputValues;
    private final int operatorOrder;
    private final int matrixIndicesCount;
    private final Expression[][] hatQuantities;
    private final Expression[] kn;
    private final Expression L;
    private static final int HAT_QUANTITIES_GENERAL_COUNT = 5;
    private static final int INPUT_VALUES_GENERAL_COUNT = 6;
    private final int actualInput;
    private final int actualHatQuantities;
    private final Transformation[] riemannBackground;
    private final Expression F;
    private final Expression HATF;

    public OneLoopInput(int operatorOrder, Expression iK, Expression K, Expression S, Expression W, Expression N, Expression M, Expression F) {
        this(operatorOrder, iK, K, S, W, N, M, F, new Transformation[0]);
    }

    public OneLoopInput(int operatorOrder, Expression iK, Expression K, Expression S, Expression W, Expression N, Expression M, Expression F, Transformation[] riemannBackground) {
        Tensor temp;
        int k;
        StringBuilder sb;
        String covariantIndicesString;
        int i;
        this.operatorOrder = operatorOrder;
        if (operatorOrder != 2 && operatorOrder != 4) {
            throw new IllegalArgumentException();
        }
        this.riemannBackground = riemannBackground;
        this.actualInput = operatorOrder + 2;
        this.actualHatQuantities = operatorOrder + 1;
        this.inputValues = new Expression[6];
        this.inputValues[0] = iK;
        this.inputValues[1] = K;
        this.inputValues[2] = S;
        this.inputValues[3] = W;
        this.inputValues[4] = N;
        this.inputValues[5] = M;
        this.checkConsistency();
        if (Tensors.parseSimple("R_lmab").getIndices().getSymmetries().availableForModification()) {
            Tensors.addSymmetry("R_lmab", IndexType.LatinLower, true, 0, 1, 3, 2);
            Tensors.addSymmetry("R_lmab", IndexType.LatinLower, false, 2, 3, 0, 1);
        }
        if (Tensors.parseSimple("R_lm").getIndices().getSymmetries().availableForModification()) {
            Tensors.addSymmetry("R_lm", IndexType.LatinLower, false, 1, 0);
        }
        this.L = Tensors.expression(Tensors.parse("L"), new Complex(operatorOrder));
        this.hatQuantities = new Expression[5][];
        this.matrixIndicesCount = this.inputValues[1].get(0).getIndices().size() - operatorOrder;
        int[] covariantIndices = new int[operatorOrder];
        for (i = 0; i < operatorOrder; ++i) {
            covariantIndices[i] = IndicesUtils.createIndex(i, IndexType.LatinLower, true);
        }
        int[] upper = new int[this.matrixIndicesCount / 2];
        int[] lower = (int[])upper.clone();
        while (i < operatorOrder + this.matrixIndicesCount / 2) {
            upper[i - operatorOrder] = IndicesUtils.createIndex(i, IndexType.LatinLower, true);
            lower[i - operatorOrder] = IndicesUtils.createIndex(i + this.matrixIndicesCount / 2, IndexType.LatinLower, false);
            ++i;
        }
        Indicator<ParseTokenSimpleTensor> indicator = new Indicator<ParseTokenSimpleTensor>(){
            private final StructureOfIndices F_TYPES = StructureOfIndices.create(IndexType.LatinLower, 2);

            @Override
            public boolean is(ParseTokenSimpleTensor object) {
                int i;
                String name = object.name;
                for (i = 0; i < 6; ++i) {
                    if (!name.equals(OneLoopInput.this.getStringInputName(i))) continue;
                    return true;
                }
                for (i = 0; i < 5; ++i) {
                    if (!name.equals(OneLoopInput.this.getStringHatQuantitieName(i))) continue;
                    return true;
                }
                if (name.equals("F") && this.F_TYPES.isStructureOf(object.indices)) {
                    return true;
                }
                return name.equals("HATF");
            }
        };
        IndicesInsertion insertion = new IndicesInsertion(IndicesFactory.createSimple(null, upper), IndicesFactory.createSimple(null, lower), indicator);
        SqrSubs n2 = new SqrSubs(Tensors.parseSimple("n_l"));
        Transformer n2Transformer = new Transformer(TraverseState.Leaving, new Transformation[]{n2});
        Transformation[] transformations = ArraysUtils.addAll(new Transformation[]{EliminateMetricsTransformation.ELIMINATE_METRICS, n2Transformer}, riemannBackground);
        for (i = 0; i < this.actualHatQuantities; ++i) {
            this.hatQuantities[i] = new Expression[operatorOrder + 1 - i];
            covariantIndicesString = IndicesUtils.toString(Arrays.copyOfRange(covariantIndices, 0, covariantIndices.length - i), OutputFormat.Redberry);
            for (int j = 0; j < operatorOrder + 1 - i; ++j) {
                sb = new StringBuilder();
                sb.append(this.getStringHatQuantitieName(i)).append(IndicesUtils.toString(Arrays.copyOfRange(covariantIndices, j, covariantIndices.length - i), OutputFormat.Redberry)).append("=iK*").append(this.getStringInputName(1 + i)).append(covariantIndicesString);
                for (k = 0; k < j; ++k) {
                    sb.append("*n").append(IndicesUtils.toString(IndicesUtils.inverseIndexState(covariantIndices[k]), OutputFormat.Redberry));
                }
                temp = Tensors.parse(sb.toString(), insertion);
                temp = this.inputValues[0].transform(temp);
                temp = this.inputValues[i + 1].transform(temp);
                temp = ExpandTransformation.expand(temp, transformations);
                for (Transformation t : transformations) {
                    temp = t.transform(temp);
                }
                this.hatQuantities[i][j] = (Expression)temp;
            }
        }
        while (i < 5) {
            this.hatQuantities[i] = new Expression[1];
            sb = new StringBuilder();
            sb.append(this.getStringHatQuantitieName(i)).append("=0");
            this.hatQuantities[i][0] = (Expression)Tensors.parse(sb.toString(), insertion);
            ++i;
        }
        this.kn = new Expression[operatorOrder + 1];
        covariantIndicesString = IndicesUtils.toString(covariantIndices, OutputFormat.Redberry);
        String matricIndices = IndicesUtils.toString(ArraysUtils.addAll(upper, lower), OutputFormat.Redberry);
        for (i = 0; i < operatorOrder + 1; ++i) {
            sb = new StringBuilder();
            sb.append("Kn").append(IndicesUtils.toString(Arrays.copyOfRange(covariantIndices, i, covariantIndices.length), OutputFormat.Redberry)).append(matricIndices).append("=K").append(covariantIndicesString).append(matricIndices);
            for (k = 0; k < i; ++k) {
                sb.append("*n").append(IndicesUtils.toString(IndicesUtils.inverseIndexState(covariantIndices[k]), OutputFormat.Redberry));
            }
            temp = Tensors.parse(sb.toString());
            temp = this.inputValues[0].transform(temp);
            temp = this.inputValues[1].transform(temp);
            temp = ExpandTransformation.expand(temp, transformations);
            for (Transformation t : transformations) {
                temp = t.transform(temp);
            }
            this.kn[i] = (Expression)temp;
        }
        int[] symmetry = new int[F.get(0).getIndices().size()];
        symmetry[0] = 1;
        symmetry[1] = 0;
        for (i = 2; i < symmetry.length; ++i) {
            symmetry[i] = i;
        }
        if (((SimpleTensor)F.get(0)).getIndices().getSymmetries().availableForModification()) {
            Tensors.addSymmetry((SimpleTensor)F.get(0), IndexType.LatinLower, true, symmetry);
        }
        this.F = F;
        covariantIndicesString = IndicesUtils.toString(Arrays.copyOfRange(covariantIndices, 0, 2), OutputFormat.Redberry);
        sb = new StringBuilder();
        sb.append("HATF").append(covariantIndicesString).append("=iK*F").append(covariantIndicesString);
        Tensor HATF = Tensors.parse(sb.toString(), insertion);
        HATF = F.transform(HATF);
        HATF = this.inputValues[0].transform(HATF);
        this.HATF = (Expression)HATF;
    }

    private String getStringInputName(int i) {
        switch (i) {
            case 0: {
                return "iK";
            }
            case 1: {
                return "K";
            }
            case 2: {
                return "S";
            }
            case 3: {
                return "W";
            }
            case 4: {
                return "N";
            }
            case 5: {
                return "M";
            }
        }
        throw new IllegalArgumentException();
    }

    private String getStringHatQuantitieName(int i) {
        switch (i) {
            case 0: {
                return "HATK";
            }
            case 1: {
                return "HATS";
            }
            case 2: {
                return "HATW";
            }
            case 3: {
                return "HATN";
            }
            case 4: {
                return "HATM";
            }
        }
        throw new IllegalArgumentException();
    }

    private void checkConsistency() {
        int i;
        for (i = 0; i < this.actualInput; ++i) {
            if (!(this.inputValues[i].get(0) instanceof SimpleTensor)) {
                throw new IllegalArgumentException();
            }
            SimpleTensor st = (SimpleTensor)this.inputValues[i].get(0);
            NameDescriptor nd = CC.getNameDescriptor(st.getName());
            if (nd.getName(null).equals(this.getStringInputName(i))) continue;
            throw new IllegalArgumentException();
        }
        while (i < 6) {
            if (this.inputValues[i] != null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        SimpleIndices indices = (SimpleIndices)this.inputValues[1].get(0).getIndices();
        StructureOfIndices structureOfIndices = indices.getStructureOfIndices();
        if (structureOfIndices.getTypeData((byte)IndexType.LatinLower.getType()).length != structureOfIndices.size()) {
            throw new IllegalArgumentException("Only Latin lower indices are legal.");
        }
        int matrixIndicesCount = indices.size() - this.operatorOrder;
        if (matrixIndicesCount % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.inputValues[0].get(0).getIndices().size() != matrixIndicesCount) {
            throw new IllegalArgumentException();
        }
        for (i = 1; i < this.actualInput; ++i) {
            structureOfIndices = ((SimpleIndices)this.inputValues[i].get(0).getIndices()).getStructureOfIndices();
            if (structureOfIndices.getTypeData((byte)IndexType.LatinLower.getType()).length != structureOfIndices.size()) {
                throw new IllegalArgumentException("Only Latin lower indices are legal.");
            }
            if (structureOfIndices.size() + i - 1 == this.operatorOrder + matrixIndicesCount) continue;
            throw new IllegalArgumentException();
        }
    }

    public Expression getInputParameter(int i) {
        return this.inputValues[i];
    }

    public Expression[] getHatQuantities(int k) {
        return (Expression[])this.hatQuantities[k].clone();
    }

    Expression[][] getHatQuantities() {
        return this.hatQuantities;
    }

    public Expression[] getKnQuantities() {
        return (Expression[])this.kn.clone();
    }

    public Expression getHatF() {
        return this.HATF;
    }

    public Expression getF() {
        return this.F;
    }

    public Expression[] getNablaS() {
        if (this.operatorOrder < 1) {
            return new Expression[0];
        }
        Expression[] nablaS = new Expression[this.getHatQuantities(1).length];
        for (int i = 0; i < nablaS.length; ++i) {
            StringBuilder sb = new StringBuilder().append("NABLAS_{l_{9}}").append(this.getHatQuantities(1)[i].get(0).getIndices().toString(OutputFormat.Redberry)).append("=0");
            nablaS[i] = (Expression)Tensors.parse(sb.toString());
        }
        return nablaS;
    }

    public Expression getL() {
        return this.L;
    }

    public int getMatrixIndicesCount() {
        return this.matrixIndicesCount;
    }

    public int getOperatorOrder() {
        return this.operatorOrder;
    }

    public Transformation[] getRiemannBackground() {
        return this.riemannBackground;
    }
}

