/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.feyncalc;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.PermutationGroup;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indexmapping.MappingsPort;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseUtils;
import cc.redberry.core.parser.preprocessor.ChangeIndicesTypesAndTensorNames;
import cc.redberry.core.parser.preprocessor.TypesAndNamesTransformer;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.StructureOfContractions;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.EliminateMetricsTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LeviCivitaSimplifyTransformation
implements Transformation {
    private static final String defaultLeviCivitaName = "eps";
    private final int leviCivita;
    private final boolean minkowskiSpace;
    private final int numberOfIndices;
    private final IndexType typeOfLeviCivitaIndices;
    private final ChangeIndicesTypesAndTensorNames tokenTransformer;
    private final Expression[] leviCivitaSimplifications;
    private static TIntObjectHashMap<ParseToken> cachedLeviCivitaSelfContractions = new TIntObjectHashMap();
    private static TIntObjectHashMap<Map<Permutation, Boolean>> cachedLeviCivitaSymmetries = new TIntObjectHashMap();

    public LeviCivitaSimplifyTransformation(SimpleTensor leviCivita, boolean minkowskiSpace) {
        LeviCivitaSimplifyTransformation.checkLeviCivita(leviCivita);
        this.leviCivita = leviCivita.getName();
        this.minkowskiSpace = minkowskiSpace;
        this.numberOfIndices = leviCivita.getIndices().size();
        this.typeOfLeviCivitaIndices = IndicesUtils.getTypeEnum(leviCivita.getIndices().get(0));
        final String leviCivitaName = CC.getNameManager().getNameDescriptor(leviCivita.getName()).getName(null);
        this.tokenTransformer = new ChangeIndicesTypesAndTensorNames(new TypesAndNamesTransformer(){

            @Override
            public IndexType newType(IndexType oldType, NameAndStructureOfIndices old) {
                return LeviCivitaSimplifyTransformation.this.typeOfLeviCivitaIndices;
            }

            @Override
            public String newName(NameAndStructureOfIndices old) {
                return old.getName().equals(LeviCivitaSimplifyTransformation.defaultLeviCivitaName) ? leviCivitaName : old.getName();
            }
        });
        this.leviCivitaSimplifications = this.getLeviCivitaSubstitutions();
    }

    @Override
    public Tensor transform(Tensor t) {
        Tensor c;
        FromChildToParentIterator iterator = new FromChildToParentIterator(t);
        while ((c = iterator.next()) != null) {
            if (c instanceof SimpleTensor && ((SimpleTensor)c).getName() == this.leviCivita && c.getIndices().size() != c.getIndices().getFree().size()) {
                iterator.set(Complex.ZERO);
            }
            if (!(c instanceof Product)) continue;
            iterator.set(this.simplifyProduct(c));
        }
        return iterator.result();
    }

    private Tensor simplifyProduct(Tensor product) {
        int i;
        ProductContent content = ((Product)product).getContent();
        IntArrayList epsPositions = new IntArrayList();
        int sizeOfComponent = content.size();
        for (i = 0; i < sizeOfComponent; ++i) {
            if (!LeviCivitaSimplifyTransformation.isLeviCivita(content.get(i), this.leviCivita)) continue;
            epsPositions.add(i);
        }
        if (epsPositions.isEmpty()) {
            return product;
        }
        StructureOfContractions fs = content.getStructureOfContractions();
        sizeOfComponent = epsPositions.size();
        HashSet<Tensor> epsComponent = new HashSet<Tensor>(this.numberOfIndices);
        for (i = 0; i < sizeOfComponent; ++i) {
            Mapping mapping;
            Tensor temp;
            for (long contraction : fs.contractions[epsPositions.get(i)]) {
                int toIndex = StructureOfContractions.getToTensorIndex(contraction);
                if (toIndex == -1 || LeviCivitaSimplifyTransformation.isLeviCivita(temp = content.get(toIndex), this.leviCivita)) continue;
                epsComponent.add(temp);
            }
            if (epsComponent.isEmpty()) continue;
            temp = Tensors.multiply(epsComponent.toArray(new Tensor[epsComponent.size()]));
            epsComponent.clear();
            int[] nArray = temp.getIndices().getFree().getAllIndices().copy();
            if (nArray.length == 1) continue;
            IntArrayList nonPermutableList = new IntArrayList();
            int[] epsIndices = content.get(epsPositions.get(i)).getIndices().getFree().getAllIndices().copy();
            for (int b = 0; b < nArray.length; ++b) {
                boolean contract = false;
                for (int a = 0; a < epsIndices.length; ++a) {
                    if (nArray[b] != IndicesUtils.inverseIndexState(epsIndices[a])) continue;
                    contract = true;
                }
                if (contract) continue;
                nonPermutableList.add(b);
            }
            int[] nonPermutableArray = nonPermutableList.toArray();
            Map<Permutation, Boolean> symmetries = LeviCivitaSimplifyTransformation.getEpsilonSymmetries(nArray.length);
            MappingsPort port = IndexMappings.createPort(temp, temp);
            while ((mapping = port.take()) != null) {
                Permutation sym = TensorUtils.getSymmetryFromMapping(nArray, mapping);
                if (!LeviCivitaSimplifyTransformation.checkNonPermutingPositions(sym, nonPermutableArray) || sym.antisymmetry() == symmetries.get(sym).booleanValue()) continue;
                return Complex.ZERO;
            }
        }
        if (epsPositions.size() == 1) {
            return product;
        }
        for (Expression exp : this.leviCivitaSimplifications) {
            product = exp.transform(product);
        }
        product = EliminateMetricsTransformation.eliminate(ExpandTransformation.expand(product, EliminateMetricsTransformation.ELIMINATE_METRICS));
        product = this.leviCivitaSimplifications[1].transform(product);
        return product;
    }

    private static boolean checkNonPermutingPositions(Permutation permutation, int[] nonPermutablePositions) {
        for (int i : nonPermutablePositions) {
            if (permutation.newIndexOf(i) == i) continue;
            return false;
        }
        return true;
    }

    private static boolean isLeviCivita(Tensor tensor, int leviCivitaName) {
        return tensor instanceof SimpleTensor && ((SimpleTensor)tensor).getName() == leviCivitaName;
    }

    private Expression getLeviCivitaSelfContraction() {
        ParseToken substitutionToken = (ParseToken)cachedLeviCivitaSelfContractions.get(this.numberOfIndices);
        if (substitutionToken == null) {
            int[] lower = new int[this.numberOfIndices];
            int[] upper = new int[this.numberOfIndices];
            for (int i = 0; i < this.numberOfIndices; ++i) {
                lower[i] = i;
                upper[i] = IndicesUtils.inverseIndexState(this.numberOfIndices + i);
            }
            SimpleTensor eps1 = Tensors.simpleTensor(defaultLeviCivitaName, IndicesFactory.createSimple(null, lower));
            SimpleTensor eps2 = Tensors.simpleTensor(defaultLeviCivitaName, IndicesFactory.createSimple(null, upper));
            Tensor lhs = Tensors.multiply(eps1, eps2);
            Tensor[][] matrix = new Tensor[this.numberOfIndices][this.numberOfIndices];
            for (int i = 0; i < this.numberOfIndices; ++i) {
                for (int j = 0; j < this.numberOfIndices; ++j) {
                    matrix[i][j] = Tensors.createKronecker(lower[i], upper[j]);
                }
            }
            Tensor rhs = TensorUtils.det(matrix);
            Expression substitution = Tensors.expression(lhs, rhs);
            substitutionToken = ParseUtils.tensor2AST(substitution);
            cachedLeviCivitaSelfContractions.put(this.numberOfIndices, (Object)substitutionToken);
        }
        Expression substitution = (Expression)this.tokenTransformer.transform(substitutionToken).toTensor();
        if (this.minkowskiSpace & this.numberOfIndices % 2 == 0) {
            substitution = Tensors.expression(substitution.get(0), Tensors.negate(substitution.get(1)));
        }
        return substitution;
    }

    private Expression[] getLeviCivitaSubstitutions() {
        Expression[] substitutions = new Expression[]{this.getLeviCivitaSelfContraction(), Tensors.expression(Tensors.createKronecker(IndicesUtils.setType(this.typeOfLeviCivitaIndices, 0), IndicesUtils.setType(this.typeOfLeviCivitaIndices, Integer.MIN_VALUE)), new Complex(this.numberOfIndices))};
        return substitutions;
    }

    private static Map<Permutation, Boolean> getEpsilonSymmetries(int indicesSize) {
        HashMap<Permutation, Boolean> symmetries = (HashMap<Permutation, Boolean>)cachedLeviCivitaSymmetries.get(indicesSize);
        if (symmetries != null) {
            return symmetries;
        }
        symmetries = new HashMap<Permutation, Boolean>();
        PermutationGroup lc = PermutationGroup.antisymmetricGroup(indicesSize);
        for (Permutation symmetry : lc) {
            symmetries.put(symmetry.toSymmetry(), symmetry.antisymmetry());
        }
        cachedLeviCivitaSymmetries.put(indicesSize, symmetries);
        return symmetries;
    }

    private static void checkLeviCivita(SimpleTensor LeviCivita) {
        SimpleIndices indices = LeviCivita.getIndices();
        if (indices.size() <= 1) {
            throw new IllegalArgumentException("Levi-Civita cannot be a scalar.");
        }
        byte type = IndicesUtils.getType(indices.get(0));
        for (int i = 1; i < indices.size(); ++i) {
            if (type == IndicesUtils.getType(indices.get(i))) continue;
            throw new IllegalArgumentException("Levi-Civita have indices with different types.");
        }
    }
}

