/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.feyncalc;

import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;

public final class FeynCalcUtils {
    public static Expression[] setMandelstam(String[][] momentums) {
        Tensor[][] tt = new Tensor[momentums.length][];
        for (int i = 0; i < tt.length; ++i) {
            tt[i] = new Tensor[momentums[i].length];
            for (int j = 0; j < tt[i].length; ++j) {
                tt[i][j] = Tensors.parse(momentums[i][j]);
            }
        }
        return FeynCalcUtils.setMandelstam(tt);
    }

    public static Expression[] setMandelstam(Tensor[][] momentums, Tensor s, Tensor t, Tensor u) {
        FeynCalcUtils.checkMandelstamInput(momentums);
        if (s.getIndices().getFree().size() != 0 || t.getIndices().getFree().size() != 0 || u.getIndices().getFree().size() != 0) {
            throw new IllegalArgumentException("Mandelstam variables should be scalar.");
        }
        Expression[] result = new Expression[10];
        for (int i = 0; i < 4; ++i) {
            result[i] = Tensors.expression(FeynCalcUtils.square(momentums[i][0]), Tensors.pow(momentums[i][1], 2));
        }
        result[i++] = Tensors.expression(Tensors.multiply(Complex.TWO, FeynCalcUtils.contract(momentums[0][0], momentums[1][0])), Tensors.sum(s, Tensors.negate(Tensors.sum(Tensors.pow(momentums[0][1], 2), Tensors.pow(momentums[1][1], 2)))));
        result[i++] = Tensors.expression(Tensors.multiply(Complex.TWO, FeynCalcUtils.contract(momentums[2][0], momentums[3][0])), Tensors.sum(s, Tensors.negate(Tensors.sum(Tensors.pow(momentums[2][1], 2), Tensors.pow(momentums[3][1], 2)))));
        result[i++] = Tensors.expression(Tensors.multiply(Complex.MINUS_TWO, FeynCalcUtils.contract(momentums[0][0], momentums[2][0])), Tensors.sum(t, Tensors.negate(Tensors.sum(Tensors.pow(momentums[0][1], 2), Tensors.pow(momentums[2][1], 2)))));
        result[i++] = Tensors.expression(Tensors.multiply(Complex.MINUS_TWO, FeynCalcUtils.contract(momentums[1][0], momentums[3][0])), Tensors.sum(t, Tensors.negate(Tensors.sum(Tensors.pow(momentums[1][1], 2), Tensors.pow(momentums[3][1], 2)))));
        result[i++] = Tensors.expression(Tensors.multiply(Complex.MINUS_TWO, FeynCalcUtils.contract(momentums[0][0], momentums[3][0])), Tensors.sum(u, Tensors.negate(Tensors.sum(Tensors.pow(momentums[0][1], 2), Tensors.pow(momentums[3][1], 2)))));
        result[i++] = Tensors.expression(Tensors.multiply(Complex.MINUS_TWO, FeynCalcUtils.contract(momentums[1][0], momentums[2][0])), Tensors.sum(u, Tensors.negate(Tensors.sum(Tensors.pow(momentums[1][1], 2), Tensors.pow(momentums[2][1], 2)))));
        return result;
    }

    public static Expression[] setMandelstam(Tensor[][] momentums) {
        return FeynCalcUtils.setMandelstam(momentums, Tensors.parse("s"), Tensors.parse("t"), Tensors.parse("u"));
    }

    private static void checkMandelstamInput(Tensor[][] momentums) {
        if (momentums.length != 4) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 4; ++i) {
            Tensor[] pair = momentums[i];
            if (pair.length != 2) {
                throw new IllegalArgumentException();
            }
            if (pair[0].getIndices().size() != 1) {
                throw new IllegalArgumentException();
            }
            if (pair[1].getIndices().size() == 0) continue;
            throw new IllegalArgumentException();
        }
    }

    private static Tensor contract(Tensor a, Tensor b) {
        return Tensors.multiplyAndRenameConflictingDummies(a, FeynCalcUtils.invertIndices(b));
    }

    private static Tensor square(Tensor tensor) {
        return Tensors.multiplyAndRenameConflictingDummies(tensor, FeynCalcUtils.invertIndices(tensor));
    }

    private static Tensor invertIndices(Tensor t) {
        Indices free = t.getIndices().getFree();
        Mapping mapping = new Mapping(free.toArray(), free.getInverted().toArray());
        return ApplyIndexMapping.applyIndexMapping(t, mapping);
    }
}

