/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import java.util.Iterator;

public interface OutputPort<T> {
    public T take();

    public static final class PortIterable<T>
    implements Iterable<T> {
        private final OutputPort<T> opu;

        public PortIterable(OutputPort<T> opu) {
            this.opu = opu;
        }

        @Override
        public Iterator<T> iterator() {
            return new PortIterator<T>(this.opu);
        }
    }

    public static final class PortIterator<T>
    implements Iterator<T> {
        private final OutputPort<T> opu;
        private T next;

        public PortIterator(OutputPort<T> opu) {
            this.opu = opu;
        }

        @Override
        public boolean hasNext() {
            this.next = this.opu.take();
            return this.next != null;
        }

        @Override
        public T next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static final class Singleton<T>
    implements OutputPort<T> {
        private T element;

        public Singleton(T element) {
            this.element = element;
        }

        @Override
        public T take() {
            T newElement = this.element;
            this.element = null;
            return newElement;
        }
    }
}

