/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

class IntTimSort {
    private static final int MIN_MERGE = 32;
    private final int[] a;
    private final int[] b;
    private static final int MIN_GALLOP = 7;
    private int minGallop = 7;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private int[] tmp;
    private int[] tmpB;
    private int stackSize = 0;
    private final int[] runBase;
    private final int[] runLen;

    private IntTimSort(int[] a, int[] b) {
        this.a = a;
        this.b = b;
        int len = a.length;
        int[] newArray = new int[len < 512 ? len >>> 1 : 256];
        this.tmp = newArray;
        int[] newArrayB = new int[len < 512 ? len >>> 1 : 256];
        this.tmpB = newArrayB;
        int stackLen = len < 120 ? 5 : (len < 1542 ? 10 : (len < 119151 ? 19 : 40));
        this.runBase = new int[stackLen];
        this.runLen = new int[stackLen];
    }

    static void sort(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException();
        }
        IntTimSort.sort(a, 0, a.length, b);
    }

    static void sort(int[] a, int lo, int hi, int[] b) {
        int runLen;
        IntTimSort.rangeCheck(a.length, lo, hi);
        int nRemaining = hi - lo;
        if (nRemaining < 2) {
            return;
        }
        if (nRemaining < 32) {
            int initRunLen = IntTimSort.countRunAndMakeAscending(a, lo, hi, b);
            IntTimSort.binarySort(a, lo, hi, lo + initRunLen, b);
            return;
        }
        IntTimSort ts = new IntTimSort(a, b);
        int minRun = IntTimSort.minRunLength(nRemaining);
        do {
            if ((runLen = IntTimSort.countRunAndMakeAscending(a, lo, hi, b)) < minRun) {
                int force = nRemaining <= minRun ? nRemaining : minRun;
                IntTimSort.binarySort(a, lo, lo + force, lo + runLen, b);
                runLen = force;
            }
            ts.pushRun(lo, runLen);
            ts.mergeCollapse();
            lo += runLen;
        } while ((nRemaining -= runLen) != 0);
        assert (lo == hi);
        ts.mergeForceCollapse();
        assert (ts.stackSize == 1);
    }

    private static void binarySort(int[] a, int lo, int hi, int start, int[] b) {
        assert (lo <= start && start <= hi);
        if (start == lo) {
            ++start;
        }
        while (start < hi) {
            int pivot = a[start];
            int pivotB = b[start];
            int left = lo;
            int right = start;
            assert (left <= right);
            while (left < right) {
                int mid = left + right >>> 1;
                if (pivot < a[mid]) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            assert (left == right);
            int n = start - left;
            switch (n) {
                case 2: {
                    a[left + 2] = a[left + 1];
                    b[left + 2] = b[left + 1];
                }
                case 1: {
                    a[left + 1] = a[left];
                    b[left + 1] = b[left];
                    break;
                }
                default: {
                    System.arraycopy(a, left, a, left + 1, n);
                    System.arraycopy(b, left, b, left + 1, n);
                }
            }
            a[left] = pivot;
            b[left] = pivotB;
            ++start;
        }
    }

    private static int countRunAndMakeAscending(int[] a, int lo, int hi, int[] b) {
        assert (lo < hi);
        int runHi = lo + 1;
        if (runHi == hi) {
            return 1;
        }
        if (a[runHi++] < a[lo]) {
            while (runHi < hi && a[runHi] < a[runHi - 1]) {
                ++runHi;
            }
            IntTimSort.reverseRange(a, lo, runHi, b);
        } else {
            while (runHi < hi && a[runHi] >= a[runHi - 1]) {
                ++runHi;
            }
        }
        return runHi - lo;
    }

    private static void reverseRange(int[] a, int lo, int hi, int[] b) {
        --hi;
        while (lo < hi) {
            int t = a[lo];
            int e = b[lo];
            b[lo] = b[hi];
            a[lo++] = a[hi];
            b[hi] = e;
            a[hi--] = t;
        }
    }

    private static int minRunLength(int n) {
        assert (n >= 0);
        int r = 0;
        while (n >= 32) {
            r |= n & 1;
            n >>= 1;
        }
        return n + r;
    }

    private void pushRun(int runBase, int runLen) {
        this.runBase[this.stackSize] = runBase;
        this.runLen[this.stackSize] = runLen;
        ++this.stackSize;
    }

    private void mergeCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1]) {
                if (this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
                this.mergeAt(n);
                continue;
            }
            if (this.runLen[n] > this.runLen[n + 1]) break;
            this.mergeAt(n);
        }
    }

    private void mergeForceCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int i) {
        assert (this.stackSize >= 2);
        assert (i >= 0);
        assert (i == this.stackSize - 2 || i == this.stackSize - 3);
        int base1 = this.runBase[i];
        int len1 = this.runLen[i];
        int base2 = this.runBase[i + 1];
        int len2 = this.runLen[i + 1];
        assert (len1 > 0 && len2 > 0);
        assert (base1 + len1 == base2);
        this.runLen[i] = len1 + len2;
        if (i == this.stackSize - 3) {
            this.runBase[i + 1] = this.runBase[i + 2];
            this.runLen[i + 1] = this.runLen[i + 2];
        }
        --this.stackSize;
        int k = IntTimSort.gallopRight(this.a[base2], this.a, base1, len1, 0);
        assert (k >= 0);
        base1 += k;
        if ((len1 -= k) == 0) {
            return;
        }
        len2 = IntTimSort.gallopLeft(this.a[base1 + len1 - 1], this.a, base2, len2, len2 - 1);
        assert (len2 >= 0);
        if (len2 == 0) {
            return;
        }
        if (len1 <= len2) {
            this.mergeLo(base1, len1, base2, len2);
        } else {
            this.mergeHi(base1, len1, base2, len2);
        }
    }

    private static int gallopLeft(int key, int[] a, int base, int len, int hint) {
        int maxOfs;
        assert (len > 0 && hint >= 0 && hint < len);
        int lastOfs = 0;
        int ofs = 1;
        if (key > a[base + hint]) {
            maxOfs = len - hint;
            while (ofs < maxOfs && key > a[base + hint + ofs]) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            lastOfs += hint;
            ofs += hint;
        } else {
            maxOfs = hint + 1;
            while (ofs < maxOfs && key <= a[base + hint - ofs]) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            int tmp = lastOfs;
            lastOfs = hint - ofs;
            ofs = hint - tmp;
        }
        assert (-1 <= lastOfs && lastOfs < ofs && ofs <= len);
        ++lastOfs;
        while (lastOfs < ofs) {
            int m = lastOfs + (ofs - lastOfs >>> 1);
            if (key > a[base + m]) {
                lastOfs = m + 1;
                continue;
            }
            ofs = m;
        }
        assert (lastOfs == ofs);
        return ofs;
    }

    private static int gallopRight(int key, int[] a, int base, int len, int hint) {
        int maxOfs;
        assert (len > 0 && hint >= 0 && hint < len);
        int ofs = 1;
        int lastOfs = 0;
        if (key < a[base + hint]) {
            maxOfs = hint + 1;
            while (ofs < maxOfs && key < a[base + hint - ofs]) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            int tmp = lastOfs;
            lastOfs = hint - ofs;
            ofs = hint - tmp;
        } else {
            maxOfs = len - hint;
            while (ofs < maxOfs && key >= a[base + hint + ofs]) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            lastOfs += hint;
            ofs += hint;
        }
        assert (-1 <= lastOfs && lastOfs < ofs && ofs <= len);
        ++lastOfs;
        while (lastOfs < ofs) {
            int m = lastOfs + (ofs - lastOfs >>> 1);
            if (key < a[base + m]) {
                ofs = m;
                continue;
            }
            lastOfs = m + 1;
        }
        assert (lastOfs == ofs);
        return ofs;
    }

    private void mergeLo(int base1, int len1, int base2, int len2) {
        assert (len1 > 0 && len2 > 0 && base1 + len1 == base2);
        int[] a = this.a;
        int[] b = this.b;
        int[] tmp = this.ensureCapacity(len1);
        System.arraycopy(a, base1, tmp, 0, len1);
        int[] tmpB = this.tmpB;
        System.arraycopy(b, base1, tmpB, 0, len1);
        int cursor1 = 0;
        int cursor2 = base2;
        int dest = base1;
        b[dest] = b[cursor2];
        a[dest++] = a[cursor2++];
        if (--len2 == 0) {
            System.arraycopy(tmp, cursor1, a, dest, len1);
            System.arraycopy(tmpB, cursor1, b, dest, len1);
            return;
        }
        if (len1 == 1) {
            System.arraycopy(a, cursor2, a, dest, len2);
            System.arraycopy(b, cursor2, b, dest, len2);
            a[dest + len2] = tmp[cursor1];
            b[dest + len2] = tmpB[cursor1];
            return;
        }
        int minGallop = this.minGallop;
        block0: while (true) {
            int count1 = 0;
            int count2 = 0;
            do {
                assert (len1 > 1 && len2 > 0);
                if (a[cursor2] < tmp[cursor1]) {
                    b[dest] = b[cursor2];
                    a[dest++] = a[cursor2++];
                    ++count2;
                    count1 = 0;
                    if (--len2 != 0) continue;
                    break block0;
                }
                b[dest] = tmpB[cursor1];
                a[dest++] = tmp[cursor1++];
                ++count1;
                count2 = 0;
                if (--len1 == 1) break block0;
            } while ((count1 | count2) < minGallop);
            do {
                assert (len1 > 1 && len2 > 0);
                count1 = IntTimSort.gallopRight(a[cursor2], tmp, cursor1, len1, 0);
                if (count1 != 0) {
                    System.arraycopy(tmp, cursor1, a, dest, count1);
                    System.arraycopy(tmpB, cursor1, b, dest, count1);
                    dest += count1;
                    cursor1 += count1;
                    if ((len1 -= count1) <= 1) break block0;
                }
                b[dest] = b[cursor2];
                a[dest++] = a[cursor2++];
                if (--len2 == 0) break block0;
                count2 = IntTimSort.gallopLeft(tmp[cursor1], a, cursor2, len2, 0);
                if (count2 != 0) {
                    System.arraycopy(a, cursor2, a, dest, count2);
                    System.arraycopy(b, cursor2, b, dest, count2);
                    dest += count2;
                    cursor2 += count2;
                    if ((len2 -= count2) == 0) break block0;
                }
                b[dest] = tmpB[cursor1];
                a[dest++] = tmp[cursor1++];
                if (--len1 == 1) break block0;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        int n = this.minGallop = minGallop < 1 ? 1 : minGallop;
        if (len1 == 1) {
            assert (len2 > 0);
            System.arraycopy(a, cursor2, a, dest, len2);
            System.arraycopy(b, cursor2, b, dest, len2);
            a[dest + len2] = tmp[cursor1];
            b[dest + len2] = tmpB[cursor1];
        } else {
            if (len1 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            assert (len2 == 0);
            assert (len1 > 1);
            System.arraycopy(tmp, cursor1, a, dest, len1);
            System.arraycopy(tmpB, cursor1, b, dest, len1);
        }
    }

    private void mergeHi(int base1, int len1, int base2, int len2) {
        assert (len1 > 0 && len2 > 0 && base1 + len1 == base2);
        int[] a = this.a;
        int[] b = this.b;
        int[] tmp = this.ensureCapacity(len2);
        int[] tmpB = this.tmpB;
        System.arraycopy(a, base2, tmp, 0, len2);
        System.arraycopy(b, base2, tmpB, 0, len2);
        int cursor1 = base1 + len1 - 1;
        int cursor2 = len2 - 1;
        int dest = base2 + len2 - 1;
        b[dest] = b[cursor1];
        a[dest--] = a[cursor1--];
        if (--len1 == 0) {
            System.arraycopy(tmp, 0, a, dest - (len2 - 1), len2);
            System.arraycopy(tmpB, 0, b, dest - (len2 - 1), len2);
            return;
        }
        if (len2 == 1) {
            System.arraycopy(a, (cursor1 -= len1) + 1, a, (dest -= len1) + 1, len1);
            System.arraycopy(b, cursor1 + 1, b, dest + 1, len1);
            a[dest] = tmp[cursor2];
            b[dest] = tmpB[cursor2];
            return;
        }
        int minGallop = this.minGallop;
        block0: while (true) {
            int count1 = 0;
            int count2 = 0;
            do {
                assert (len1 > 0 && len2 > 1);
                if (tmp[cursor2] < a[cursor1]) {
                    b[dest] = b[cursor1];
                    a[dest--] = a[cursor1--];
                    ++count1;
                    count2 = 0;
                    if (--len1 != 0) continue;
                    break block0;
                }
                b[dest] = tmpB[cursor2];
                a[dest--] = tmp[cursor2--];
                ++count2;
                count1 = 0;
                if (--len2 == 1) break block0;
            } while ((count1 | count2) < minGallop);
            do {
                assert (len1 > 0 && len2 > 1);
                count1 = len1 - IntTimSort.gallopRight(tmp[cursor2], a, base1, len1, len1 - 1);
                if (count1 != 0) {
                    System.arraycopy(a, (cursor1 -= count1) + 1, a, (dest -= count1) + 1, count1);
                    System.arraycopy(b, cursor1 + 1, b, dest + 1, count1);
                    if ((len1 -= count1) == 0) break block0;
                }
                b[dest] = tmpB[cursor2];
                a[dest--] = tmp[cursor2--];
                if (--len2 == 1) break block0;
                count2 = len2 - IntTimSort.gallopLeft(a[cursor1], tmp, 0, len2, len2 - 1);
                if (count2 != 0) {
                    System.arraycopy(tmpB, (cursor2 -= count2) + 1, b, (dest -= count2) + 1, count2);
                    System.arraycopy(tmp, cursor2 + 1, a, dest + 1, count2);
                    if ((len2 -= count2) <= 1) break block0;
                }
                b[dest] = b[cursor1];
                a[dest--] = a[cursor1--];
                if (--len1 == 0) break block0;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        int n = this.minGallop = minGallop < 1 ? 1 : minGallop;
        if (len2 == 1) {
            assert (len1 > 0);
            System.arraycopy(a, (cursor1 -= len1) + 1, a, (dest -= len1) + 1, len1);
            System.arraycopy(b, cursor1 + 1, b, dest + 1, len1);
            a[dest] = tmp[cursor2];
            b[dest] = tmpB[cursor2];
        } else {
            if (len2 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            assert (len1 == 0);
            assert (len2 > 0);
            System.arraycopy(tmp, 0, a, dest - (len2 - 1), len2);
            System.arraycopy(tmpB, 0, b, dest - (len2 - 1), len2);
        }
    }

    private int[] ensureCapacity(int minCapacity) {
        if (this.tmp.length < minCapacity) {
            int newSize = minCapacity;
            newSize |= newSize >> 1;
            newSize |= newSize >> 2;
            newSize |= newSize >> 4;
            newSize |= newSize >> 8;
            newSize |= newSize >> 16;
            newSize = ++newSize < 0 ? minCapacity : Math.min(newSize, this.a.length >>> 1);
            int[] newArray = new int[newSize];
            this.tmp = newArray;
            int[] newArrayB = new int[newSize];
            this.tmpB = newArrayB;
        }
        return this.tmp;
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }
}

