/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

public final class HashFunctions {
    public static final long FNV_BASIS = -2128831035L;
    public static final long FNV_PRIME_32 = 16777619L;
    public static final long FNV_PRIME_64 = 1099511628211L;

    private HashFunctions() {
    }

    public static int mix(int a, int b, int c) {
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >>> 13);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >>> 15;
    }

    public static int JenkinWang32shift(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key;
    }

    public static int Wang32shiftmult(int key) {
        int c2 = 668265261;
        key = key ^ 0x3D ^ key >>> 16;
        key += key << 3;
        key ^= key >>> 4;
        key *= c2;
        key ^= key >>> 15;
        return key;
    }

    public static long JenkinWang64shift(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >>> 24;
        key = key + (key << 3) + (key << 8);
        key ^= key >>> 14;
        key = key + (key << 2) + (key << 4);
        key ^= key >>> 28;
        key += key << 31;
        return key;
    }

    public static int Wang64to32shift(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 18);
        key ^= key >>> 31;
        key *= 21L;
        key ^= key >>> 11;
        key += key << 6;
        key ^= key >>> 22;
        return (int)key;
    }

    public static int FVN32hash(byte[] bytes) {
        long hash = -2128831035L;
        for (int i = 0; i < bytes.length; ++i) {
            hash ^= (long)(0xFF & bytes[i]);
            hash *= 16777619L;
        }
        return (int)hash;
    }

    public static int FVN32hash(int c) {
        long hash = -2128831035L;
        hash ^= (long)(c >>> 24);
        hash *= 16777619L;
        hash ^= (long)(0xFF & c >>> 16);
        hash *= 16777619L;
        hash ^= (long)(0xFF & c >>> 8);
        hash *= 16777619L;
        hash ^= (long)(0xFF & c);
        return (int)(hash *= 16777619L);
    }

    public static long FVN64hash(byte[] bytes) {
        long hash = -2128831035L;
        for (int i = 0; i < bytes.length; ++i) {
            hash ^= (long)(0xFF & bytes[i]);
            hash *= 1099511628211L;
        }
        return hash;
    }

    public static long FVN64hash(long c) {
        long hash = -2128831035L;
        hash ^= c >>> 56;
        hash *= 1099511628211L;
        hash ^= 0xFFL & c >>> 48;
        hash *= 1099511628211L;
        hash ^= 0xFFL & c >>> 40;
        hash *= 1099511628211L;
        hash ^= 0xFFL & c >>> 32;
        hash *= 1099511628211L;
        hash ^= 0xFFL & c >>> 24;
        hash *= 1099511628211L;
        hash ^= 0xFFL & c >>> 16;
        hash *= 1099511628211L;
        hash ^= 0xFFL & c >>> 8;
        hash *= 1099511628211L;
        hash ^= 0xFFL & c;
        return hash *= 1099511628211L;
    }

    public static int FVN64to32hash(long c) {
        long hash = -2128831035L;
        hash ^= c >>> 56;
        hash *= 16777619L;
        hash ^= 0xFFL & c >>> 48;
        hash *= 16777619L;
        hash ^= 0xFFL & c >>> 40;
        hash *= 16777619L;
        hash ^= 0xFFL & c >>> 32;
        hash *= 16777619L;
        hash ^= 0xFFL & c >>> 24;
        hash *= 16777619L;
        hash ^= 0xFFL & c >>> 16;
        hash *= 16777619L;
        hash ^= 0xFFL & c >>> 8;
        hash *= 16777619L;
        hash ^= 0xFFL & c;
        return (int)(hash *= 16777619L);
    }

    public static int MurmurHash2(byte[] data, int seed) {
        int len;
        int m = 1540483477;
        int r = 24;
        int h = seed ^ len;
        int i = 0;
        for (len = data.length; len >= 4; len -= 4) {
            int k = data[i] & 0xFF;
            k |= (data[i + 1] & 0xFF) << 8;
            k |= (data[i + 2] & 0xFF) << 16;
            k |= (data[i + 3] & 0xFF) << 24;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
            i += 4;
        }
        switch (len) {
            case 3: {
                h ^= (data[i + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[i + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[i] & 0xFF;
                h *= m;
            }
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static int MurmurHash2(int c, int seed) {
        int m = 1540483477;
        int h = seed ^ 4;
        c *= m;
        c ^= c >>> 24;
        h *= m;
        h ^= (c *= m);
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static int MurmurHash2(byte[] data) {
        return HashFunctions.MurmurHash2(data, 790246067);
    }

    public static int MurmurHash2(int c) {
        return HashFunctions.MurmurHash2(c, 790246067);
    }
}

