/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.iterator.DummyPayload;
import cc.redberry.core.tensor.iterator.Payload;
import cc.redberry.core.tensor.iterator.PayloadFactory;
import cc.redberry.core.tensor.iterator.StackPosition;
import cc.redberry.core.tensor.iterator.TraverseGuide;
import cc.redberry.core.tensor.iterator.TraverseState;
import cc.redberry.core.tensor.iterator.TreeIterator;
import cc.redberry.core.tensor.iterator.TreeTraverseIterator;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TCollections;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;

public final class SubstitutionIterator
implements TreeIterator {
    private static final TIntSet EMPTY_INT_SET = TCollections.unmodifiableSet((TIntSet)new TIntHashSet(0));
    private final TreeTraverseIterator<ForbiddenContainer> innerIterator;
    private static final ForbiddenContainer scalarFunctionContainer = new ForbiddenContainer(){

        @Override
        public TIntSet getForbidden() {
            return EMPTY_INT_SET;
        }

        @Override
        public void submit(TIntSet removed, TIntSet added) {
        }

        @Override
        public Tensor onLeaving(StackPosition<ForbiddenContainer> stackPosition) {
            if (!stackPosition.isModified()) {
                return null;
            }
            StackPosition<ForbiddenContainer> prev = stackPosition.previous();
            if (prev == null) {
                return null;
            }
            Tensor tensor = stackPosition.getTensor();
            tensor = ApplyIndexMapping.renameDummy(tensor, prev.getPayload().getForbidden().toArray());
            prev.getPayload().submit(EMPTY_INT_SET, (TIntSet)TensorUtils.getAllIndicesNamesT(tensor));
            return tensor;
        }
    };
    private static final ForbiddenContainer EMPTY_CONTAINER = new ForbiddenContainer(){

        @Override
        public TIntSet getForbidden() {
            return EMPTY_INT_SET;
        }

        @Override
        public void submit(TIntSet removed, TIntSet added) {
        }

        @Override
        public Tensor onLeaving(StackPosition<ForbiddenContainer> stackPosition) {
            return null;
        }
    };

    public SubstitutionIterator(Tensor tensor) {
        this.innerIterator = new TreeTraverseIterator<ForbiddenContainer>(tensor, new FCPayloadFactory());
    }

    public SubstitutionIterator(Tensor tensor, TraverseGuide traverseGuide) {
        this.innerIterator = new TreeTraverseIterator<ForbiddenContainer>(tensor, traverseGuide, new FCPayloadFactory());
    }

    @Override
    public Tensor next() {
        TraverseState nextState;
        while ((nextState = this.innerIterator.next()) == TraverseState.Entering) {
        }
        if (nextState == null) {
            return null;
        }
        return this.innerIterator.current();
    }

    public void unsafeSet(Tensor tensor) {
        this.innerIterator.set(tensor);
    }

    @Override
    public void set(Tensor tensor) {
        this.set(tensor, true);
    }

    public void set(Tensor tensor, boolean supposeIndicesAreAdded) {
        StackPosition<ForbiddenContainer> previous;
        Tensor oldTensor = this.innerIterator.current();
        if (oldTensor == tensor) {
            return;
        }
        if (TensorUtils.isZeroOrIndeterminate(tensor)) {
            this.innerIterator.set(tensor);
            return;
        }
        if (!tensor.getIndices().getFree().equalsRegardlessOrder(oldTensor.getIndices().getFree())) {
            throw new RuntimeException("Substitution with different free indices.");
        }
        if (supposeIndicesAreAdded && (previous = this.innerIterator.currentStackPosition().previous()) != null) {
            TIntHashSet oldDummyIndices = TensorUtils.getAllDummyIndicesT(oldTensor);
            TIntHashSet newDummyIndices = TensorUtils.getAllDummyIndicesT(tensor);
            TIntHashSet added = new TIntHashSet((TIntCollection)newDummyIndices);
            added.removeAll((TIntCollection)oldDummyIndices);
            if (!added.isEmpty() || previous.isPayloadInitialized()) {
                ForbiddenContainer fc = previous.getPayload();
                TIntHashSet removed = new TIntHashSet((TIntCollection)oldDummyIndices);
                removed.removeAll((TIntCollection)newDummyIndices);
                fc.submit((TIntSet)removed, (TIntSet)added);
            }
        }
        this.innerIterator.set(tensor);
    }

    public void safeSet(Tensor tensor) {
        if (this.innerIterator.current() != tensor) {
            this.set(ApplyIndexMapping.renameDummy(tensor, this.getForbidden()));
        }
    }

    public boolean isCurrentModified() {
        return this.innerIterator.currentStackPosition().isModified();
    }

    @Override
    public Tensor result() {
        return this.innerIterator.result();
    }

    @Override
    public int depth() {
        return this.innerIterator.depth();
    }

    public int[] getForbidden() {
        StackPosition<ForbiddenContainer> previous = this.innerIterator.currentStackPosition().previous();
        if (previous == null) {
            return new int[0];
        }
        return previous.getPayload().getForbidden().toArray();
    }

    private static final class TransparentFC
    extends DummyPayload<ForbiddenContainer>
    implements ForbiddenContainer {
        private final ForbiddenContainer parent;

        private TransparentFC(ForbiddenContainer parent) {
            this.parent = parent;
        }

        @Override
        public TIntSet getForbidden() {
            return this.parent.getForbidden();
        }

        @Override
        public void submit(TIntSet removed, TIntSet added) {
            this.parent.submit(removed, added);
        }
    }

    private static final class TopProductFC
    extends AbstractFC {
        private TopProductFC(StackPosition<ForbiddenContainer> position) {
            super(position);
        }

        @Override
        public void insureInitialized() {
            if (this.forbidden != null) {
                return;
            }
            this.forbidden = TensorUtils.getAllIndicesNamesT(this.tensor);
        }

        @Override
        public void submit(TIntSet removed, TIntSet added) {
            this.insureInitialized();
            assert (!new TIntHashSet((TIntCollection)added).removeAll((TIntCollection)removed));
            this.forbidden.addAll((TIntCollection)added);
            this.forbidden.removeAll((TIntCollection)removed);
        }
    }

    private static final class SumFC
    extends AbstractFC {
        private int[] allDummyIndices;
        private BitArray[] usedArrays;

        private SumFC(StackPosition<ForbiddenContainer> position) {
            super(position);
        }

        @Override
        public void insureInitialized() {
            int i;
            if (this.forbidden != null) {
                return;
            }
            this.forbidden = ((ForbiddenContainer)this.position.previous().getPayload()).getForbidden();
            TIntHashSet allDummyIndicesT = TensorUtils.getAllDummyIndicesT(this.tensor);
            this.allDummyIndices = allDummyIndicesT.toArray();
            Arrays.sort(this.allDummyIndices);
            int size = this.tensor.size();
            this.usedArrays = new BitArray[this.allDummyIndices.length];
            for (i = this.allDummyIndices.length - 1; i >= 0; --i) {
                this.usedArrays[i] = new BitArray(size);
            }
            for (i = size - 1; i >= 0; --i) {
                TIntHashSet dummy = TensorUtils.getAllDummyIndicesT(this.tensor.get(i));
                TIntIterator iterator = dummy.iterator();
                while (iterator.hasNext()) {
                    this.usedArrays[Arrays.binarySearch(this.allDummyIndices, iterator.next())].set(i);
                }
            }
        }

        @Override
        public void submit(TIntSet removed, TIntSet added) {
            int iIndex;
            this.insureInitialized();
            TIntSet parentRemoved = null;
            for (int index : removed) {
                iIndex = Arrays.binarySearch(this.allDummyIndices, index);
                this.usedArrays[iIndex].clear(this.position.currentIndex());
                if (this.usedArrays[iIndex].bitCount() != 0) continue;
                if (parentRemoved == null) {
                    parentRemoved = new TIntHashSet(removed.size());
                }
                parentRemoved.add(index);
            }
            if (parentRemoved == null) {
                parentRemoved = EMPTY_INT_SET;
            }
            TIntHashSet parentAdded = new TIntHashSet((TIntCollection)added);
            TIntIterator iterator = parentAdded.iterator();
            while (iterator.hasNext()) {
                iIndex = Arrays.binarySearch(this.allDummyIndices, iterator.next());
                if (iIndex < 0) continue;
                if (!this.usedArrays[iIndex].isEmpty()) {
                    iterator.remove();
                }
                this.usedArrays[iIndex].set(this.position.currentIndex());
            }
            ((ForbiddenContainer)this.position.previous().getPayload()).submit(parentRemoved, (TIntSet)parentAdded);
        }

        @Override
        public TIntSet getForbidden() {
            this.insureInitialized();
            return new TIntHashSet((TIntCollection)this.forbidden);
        }
    }

    private static final class ProductFC
    extends AbstractFC {
        private ProductFC(StackPosition<ForbiddenContainer> position) {
            super(position);
        }

        @Override
        public void insureInitialized() {
            if (this.forbidden != null) {
                return;
            }
            this.forbidden = new TIntHashSet((TIntCollection)((ForbiddenContainer)this.position.previous().getPayload()).getForbidden());
            this.forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(this.tensor));
        }

        @Override
        public void submit(TIntSet removed, TIntSet added) {
            this.insureInitialized();
            assert (!new TIntHashSet((TIntCollection)added).removeAll((TIntCollection)removed));
            this.forbidden.addAll((TIntCollection)added);
            this.forbidden.removeAll((TIntCollection)removed);
            ((ForbiddenContainer)this.position.previous().getPayload()).submit(removed, added);
        }
    }

    private static abstract class AbstractFC
    extends DummyPayload<ForbiddenContainer>
    implements ForbiddenContainer {
        protected final StackPosition<ForbiddenContainer> position;
        protected TIntSet forbidden = null;
        protected final Tensor tensor;

        private AbstractFC(StackPosition<ForbiddenContainer> position) {
            this.position = position;
            this.tensor = position.getInitialTensor();
        }

        public abstract void insureInitialized();

        @Override
        public TIntSet getForbidden() {
            this.insureInitialized();
            TIntHashSet result = new TIntHashSet((TIntCollection)this.forbidden);
            result.removeAll((TIntCollection)TensorUtils.getAllIndicesNamesT(this.tensor.get(this.position.currentIndex())));
            return result;
        }
    }

    private class FCPayloadFactory
    implements PayloadFactory<ForbiddenContainer> {
        private FCPayloadFactory() {
        }

        @Override
        public boolean allowLazyInitialization() {
            return true;
        }

        @Override
        public ForbiddenContainer create(StackPosition<ForbiddenContainer> stackPosition) {
            Tensor tensor = stackPosition.getInitialTensor();
            StackPosition<ForbiddenContainer> previousPosition = stackPosition.previous();
            ForbiddenContainer parent = previousPosition == null ? EMPTY_CONTAINER : previousPosition.getPayload();
            if (parent == EMPTY_CONTAINER) {
                if (tensor instanceof Product) {
                    return new TopProductFC(stackPosition);
                }
                return EMPTY_CONTAINER;
            }
            if (tensor instanceof Product) {
                return new ProductFC(stackPosition);
            }
            if (tensor instanceof Sum) {
                return new SumFC(stackPosition);
            }
            if (tensor instanceof TensorField) {
                return EMPTY_CONTAINER;
            }
            if (tensor instanceof ScalarFunction) {
                return scalarFunctionContainer;
            }
            return new TransparentFC(parent);
        }
    }

    private static interface ForbiddenContainer
    extends Payload<ForbiddenContainer> {
        public TIntSet getForbidden();

        public void submit(TIntSet var1, TIntSet var2);
    }
}

