/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.fractions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.Indicator;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;
import java.util.List;

public final class NumeratorDenominator {
    public final Tensor numerator;
    public final Tensor denominator;
    public static Indicator<Tensor> defaultDenominatorIndicator = new Indicator<Tensor>(){

        @Override
        public boolean is(Tensor tensor) {
            if (tensor instanceof Power) {
                Tensor exponent = tensor.get(1);
                if (exponent instanceof Complex) {
                    return NumberUtils.isRealNegative((Complex)exponent);
                }
                if (exponent instanceof Product) {
                    return ((Product)exponent).getFactor().isMinusOne();
                }
            }
            return false;
        }
    };
    public static Indicator<Tensor> integerDenominatorIndicator = new Indicator<Tensor>(){

        @Override
        public boolean is(Tensor tensor) {
            return TensorUtils.isNegativeIntegerPower(tensor);
        }
    };

    private NumeratorDenominator(Tensor numerator, Tensor denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Tensor getNumerator() {
        return this.numerator;
    }

    public Tensor getDenominator() {
        return this.denominator;
    }

    public static NumeratorDenominator getNumeratorAndDenominator(Tensor tensor) {
        return NumeratorDenominator.getNumeratorAndDenominator(tensor, defaultDenominatorIndicator);
    }

    public static NumeratorDenominator getNumeratorAndDenominator(Tensor tensor, Indicator<Tensor> denominatorIndicator) {
        if (denominatorIndicator.is(tensor)) {
            return new NumeratorDenominator(Complex.ONE, Tensors.reciprocal(tensor));
        }
        if (tensor instanceof Power && tensor.get(1) instanceof Sum) {
            List<Tensor> powers = NumeratorDenominator.expandPower(tensor);
            ProductBuilder denominator = new ProductBuilder();
            ProductBuilder numerator = new ProductBuilder();
            for (Tensor power : powers) {
                if (denominatorIndicator.is(power)) {
                    denominator.put(Tensors.reciprocal(power));
                    continue;
                }
                numerator.put(power);
            }
            return new NumeratorDenominator(numerator.build(), denominator.build());
        }
        if (!(tensor instanceof Product)) {
            return new NumeratorDenominator(tensor, Complex.ONE);
        }
        ProductBuilder denominators = new ProductBuilder();
        Tensor temp = tensor;
        for (int i = tensor.size() - 1; i >= 0; --i) {
            Tensor t = tensor.get(i);
            if (!denominatorIndicator.is(t)) continue;
            Tensor exponent = Tensors.negate(t.get(1));
            denominators.put(Tensors.pow(t.get(0), exponent));
            temp = temp instanceof Product ? ((Product)temp).remove(i) : Complex.ONE;
        }
        return new NumeratorDenominator(temp, denominators.build());
    }

    private static List<Tensor> expandPower(Tensor power) {
        ArrayList<Tensor> powers = new ArrayList<Tensor>(power.get(1).size());
        for (Tensor exponent : power.get(1)) {
            powers.add(Tensors.pow(power.get(0), exponent));
        }
        return powers;
    }
}

