/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Element;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.QuotientRing;

public class Quotient<C extends GcdRingElem<C>>
implements GcdRingElem<Quotient<C>> {
    public final QuotientRing<C> ring;
    public final GenPolynomial<C> num;
    public final GenPolynomial<C> den;

    public Quotient(QuotientRing<C> r, GenPolynomial<C> n) {
        this(r, n, (GenPolynomial<C>)r.ring.getONE(), true);
    }

    public Quotient(QuotientRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d) {
        this(r, n, d, false);
    }

    protected Quotient(QuotientRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d, boolean isred) {
        GcdRingElem lc;
        GenPolynomial<C> gcd;
        if (d == null || ((GenPolynomial)d).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (((GenPolynomial)d).signum() < 0) {
            n = ((GenPolynomial)n).negate();
            d = ((GenPolynomial)d).negate();
        }
        if (!isred && !(gcd = this.ring.gcd((GenPolynomial<GenPolynomial<C>>)n, (GenPolynomial<GenPolynomial<C>>)d)).isONE()) {
            n = this.ring.divide((GenPolynomial<GenPolynomial<C>>)n, (GenPolynomial<GenPolynomial<C>>)gcd);
            d = this.ring.divide((GenPolynomial<GenPolynomial<C>>)d, (GenPolynomial<GenPolynomial<C>>)gcd);
        }
        if (!(lc = (GcdRingElem)((GenPolynomial)d).leadingBaseCoefficient()).isONE() && lc.isUnit()) {
            lc = (GcdRingElem)lc.inverse();
            n = ((GenPolynomial)n).multiply((GenPolynomial<GcdRingElem>)((Object)lc));
            d = ((GenPolynomial)d).multiply((GenPolynomial<GcdRingElem>)((Object)lc));
        }
        this.num = n;
        this.den = d;
    }

    @Override
    public QuotientRing<C> factory() {
        return this.ring;
    }

    @Override
    public Quotient<C> copy() {
        return new Quotient<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        String s = "{ " + this.num.toString(this.ring.ring.getVars());
        if (!this.den.isONE()) {
            s = s + " | " + this.den.toString(this.ring.ring.getVars());
        }
        return s + " }";
    }

    @Override
    public int compareTo(Quotient<C> b) {
        int s2;
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -b.signum();
        }
        int s1 = this.num.signum();
        int t = (s1 - (s2 = b.num.signum())) / 2;
        if (t != 0) {
            return t;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = this.num.multiply(b.den);
        GenPolynomial<GenPolynomial<C>> s = this.den.multiply(b.num);
        return r.compareTo((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)s);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Quotient)) {
            return false;
        }
        Quotient a = null;
        try {
            a = (Quotient)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.num.equals(a.num) && this.den.equals(a.den);
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    @Override
    public Quotient<C> abs() {
        return new Quotient<C>(this.ring, this.num.abs(), this.den, true);
    }

    @Override
    public Quotient<C> sum(Quotient<C> S) {
        GenPolynomial<GenPolynomial<Object>> f;
        GenPolynomial<C> sd;
        GenPolynomial<GenPolynomial<C>> d;
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenPolynomial<GenPolynomial<C>> n = this.num.sum(S.num);
            return new Quotient<GenPolynomial<C>>(this.ring, n);
        }
        if (this.den.isONE()) {
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> n = this.num.multiply(S.den);
            n = n.sum((GenPolynomial<GenPolynomial<C>>)S.num);
            return new Quotient<GenPolynomial<C>>(this.ring, n, S.den, true);
        }
        if (S.den.isONE()) {
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> n = S.num.multiply(this.den);
            n = n.sum((GenPolynomial<GenPolynomial<C>>)this.num);
            return new Quotient<GenPolynomial<C>>(this.ring, n, this.den, true);
        }
        GenPolynomial<C> g = this.ring.gcd(this.den, S.den);
        if (g.isONE()) {
            d = this.den;
            sd = S.den;
        } else {
            d = this.ring.divide(this.den, g);
            sd = this.ring.divide(S.den, g);
        }
        GenPolynomial<GenPolynomial<Object>> n = this.num.multiply(sd);
        n = n.sum((GenPolynomial<Object>)d.multiply(S.num));
        if (n.isZERO()) {
            return this.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> dd = this.den;
        if (!g.isONE() && !(f = this.ring.gcd(n, g)).isONE()) {
            n = this.ring.divide(n, f);
            dd = this.ring.divide(this.den, f);
        }
        d = dd.multiply((GenPolynomial<Object>)sd);
        return new Quotient<GenPolynomial<Object>>(this.ring, n, d, true);
    }

    @Override
    public Quotient<C> negate() {
        return new Quotient<C>(this.ring, this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Quotient<C> subtract(Quotient<C> S) {
        return this.sum((Quotient<C>)S.negate());
    }

    @Override
    public Quotient<C> divide(Quotient<C> S) {
        return this.multiply((C)S.inverse());
    }

    @Override
    public Quotient<C> inverse() {
        return new Quotient<C>(this.ring, this.den, this.num, true);
    }

    @Override
    public Quotient<C> remainder(Quotient<C> S) {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return this.ring.getZERO();
    }

    @Override
    public Quotient<C> multiply(Quotient<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenPolynomial<GenPolynomial<C>> n = this.num.multiply(S.num);
            return new Quotient<GenPolynomial<C>>(this.ring, n);
        }
        if (this.den.isONE()) {
            GenPolynomial<C> g = this.ring.gcd(this.num, S.den);
            GenPolynomial<GenPolynomial<C>> n = this.ring.divide(this.num, g);
            GenPolynomial<C> d = this.ring.divide(S.den, g);
            n = n.multiply(S.num);
            return new Quotient<C>(this.ring, n, d, true);
        }
        if (S.den.isONE()) {
            GenPolynomial<C> g = this.ring.gcd(S.num, this.den);
            GenPolynomial<GenPolynomial<C>> n = this.ring.divide(S.num, g);
            GenPolynomial<C> d = this.ring.divide(this.den, g);
            n = n.multiply(this.num);
            return new Quotient<C>(this.ring, n, d, true);
        }
        GenPolynomial<C> g = this.ring.gcd(this.num, S.den);
        GenPolynomial<GenPolynomial<C>> n = this.ring.divide(this.num, g);
        GenPolynomial<C> sd = this.ring.divide(S.den, g);
        GenPolynomial<C> f = this.ring.gcd(this.den, S.num);
        GenPolynomial<GenPolynomial<C>> d = this.ring.divide(this.den, f);
        GenPolynomial<C> sn = this.ring.divide(S.num, f);
        n = n.multiply(sn);
        d = d.multiply(sd);
        return new Quotient<C>(this.ring, n, d, true);
    }

    @Override
    public Quotient<C> multiply(GenPolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenPolynomial<C> gcd = this.ring.gcd(b, this.den);
        GenPolynomial<C> d = this.den;
        if (!gcd.isONE()) {
            b = this.ring.divide(b, gcd);
            d = this.ring.divide(d, gcd);
        }
        if (this.isONE()) {
            return new Quotient<C>(this.ring, b, d, true);
        }
        GenPolynomial<GenPolynomial<C>> n = this.num.multiply(b);
        return new Quotient<GenPolynomial<C>>(this.ring, n, d, true);
    }

    @Override
    public Quotient<C> multiply(C b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenPolynomial<C> n = this.num.multiply(b);
        return new Quotient<C>(this.ring, n, this.den, true);
    }

    public Quotient<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        GcdRingElem lbc = (GcdRingElem)this.num.leadingBaseCoefficient();
        if (!lbc.isUnit()) {
            return this;
        }
        lbc = (GcdRingElem)lbc.inverse();
        lbc = (GcdRingElem)lbc.abs();
        GenPolynomial<GcdRingElem> n = this.num.multiply(lbc);
        GenPolynomial<GcdRingElem> d = this.den.multiply(lbc);
        return new Quotient<GcdRingElem>(this.ring, n, d, true);
    }

    @Override
    public Quotient<C> gcd(Quotient<C> b) {
        if (b == null || b.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return b;
        }
        return this.ring.getONE();
    }

    public Quotient<C>[] egcd(Quotient<C> b) {
        Quotient[] ret = new Quotient[]{null, null, null};
        if (b == null || b.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = b;
            return ret;
        }
        Element two = this.ring.ring.fromInteger(2L);
        ret[0] = this.ring.getONE();
        ret[1] = this.multiply(two).inverse();
        ret[2] = b.multiply(two).inverse();
        return ret;
    }
}

