/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.Modular;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModularRingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.PolynomialTaylorFunction;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.UnivPowerSeries;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.UnivPowerSeriesRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Element;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.HenselUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;

public class HenselMultUtil {
    private static final boolean debug = false;

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> C, List<MOD> V, long d, long k) throws NoLiftingException {
        GenPolynomialRing pkfac = C.ring;
        if (pkfac.nvar == 1) {
            return HenselUtil.liftDiophant(A, B, C, k);
        }
        if (!pkfac.equals(A.ring)) {
            throw new IllegalArgumentException("A.ring != pkfac: " + A.ring + " != " + pkfac);
        }
        ArrayList<MOD> Vp = new ArrayList<MOD>(V);
        GcdRingElem v = (GcdRingElem)Vp.remove(Vp.size() - 1);
        GenPolynomial mon = pkfac.getONE();
        GenPolynomial<Element> xv = pkfac.univariate(0, 1L);
        xv = xv.subtract(pkfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal()));
        ModularRingFactory cf = (ModularRingFactory)pkfac.coFac;
        GcdRingElem vp = (GcdRingElem)cf.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
        GenPolynomialRing ckfac = pkfac.contract(1);
        GenPolynomial<GcdRingElem> Ap = PolyUtil.evaluateMain(ckfac, A, vp);
        GenPolynomial<GcdRingElem> Bp = PolyUtil.evaluateMain(ckfac, B, vp);
        GenPolynomial<GcdRingElem> Cp = PolyUtil.evaluateMain(ckfac, C, vp);
        List<GenPolynomial<GcdRingElem>> su = HenselMultUtil.liftDiophant(Ap, Bp, Cp, Vp, d, k);
        if (pkfac.nvar != 2 || !HenselUtil.isDiophantLift(Bp, Ap, su.get(0), su.get(1), Cp)) {
            // empty if block
        }
        if (!ckfac.equals(su.get((int)0).ring)) {
            throw new IllegalArgumentException("qfac != ckfac: " + su.get((int)0).ring + " != " + ckfac);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pkfac);
        String[] mn = new String[]{pkfac.getVars()[pkfac.nvar - 1]};
        GenPolynomialRing qrfac = new GenPolynomialRing(ckfac, 1, mn);
        ArrayList<GenPolynomial<MOD>> sup = new ArrayList<GenPolynomial<MOD>>(su.size());
        ArrayList<GenPolynomial<BigInteger>> supi = new ArrayList<GenPolynomial<BigInteger>>(su.size());
        for (GenPolynomial<GcdRingElem> s : su) {
            GenPolynomial<GcdRingElem> sp = s.extend(pkfac, 0, 0L);
            sup.add(sp);
            GenPolynomial<BigInteger> spi = PolyUtil.integerFromModularCoefficients(ifac, sp);
            supi.add(spi);
        }
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(ifac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(ifac, B);
        GenPolynomial<BigInteger> Ci = PolyUtil.integerFromModularCoefficients(ifac, C);
        GenPolynomial<Iterable<BigInteger>> E = Ci;
        E = E.subtract((Iterable<BigInteger>)Bi.multiply((BigInteger)((Object)((GenPolynomial)supi.get(0)))));
        if ((E = E.subtract((Iterable<BigInteger>)Ai.multiply((BigInteger)((Object)((GenPolynomial)supi.get(1)))))).isZERO()) {
            return sup;
        }
        GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pkfac, E);
        if (Ep.isZERO()) {
            return sup;
        }
        int e = 1;
        while ((long)e <= d) {
            GenPolynomial Epr = PolyUtil.recursive(qrfac, Ep);
            UnivPowerSeriesRing<GenPolynomial<Element>> psfac = new UnivPowerSeriesRing<GenPolynomial<Element>>(qrfac);
            PolynomialTaylorFunction F = new PolynomialTaylorFunction(Epr);
            Element vq = ckfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
            UnivPowerSeries<Element> Epst = psfac.seriesOfTaylor(F, (GenPolynomial<Element>)vq);
            GenPolynomial cm = (GenPolynomial)Epst.coefficient(e);
            List<GenPolynomial<GcdRingElem>> S = HenselMultUtil.liftDiophant(Ap, Bp, cm, Vp, d, k);
            if (!ckfac.coFac.equals(S.get((int)0).ring.coFac)) {
                throw new IllegalArgumentException("ckfac != pkfac: " + ckfac.coFac + " != " + S.get((int)0).ring.coFac);
            }
            if (pkfac.nvar != 2 || !HenselUtil.isDiophantLift(Ap, Bp, S.get(1), S.get(0), cm)) {
                // empty if block
            }
            mon = mon.multiply(xv);
            int i = 0;
            supi = new ArrayList(su.size());
            for (GenPolynomial<GcdRingElem> dd : S) {
                GenPolynomial<RingElem<Object>> de = dd.extend(pkfac, 0, 0L);
                GenPolynomial dm = de.multiply((GcdRingElem)((Object)mon));
                de = ((GenPolynomial)sup.get(i)).sum(dm);
                sup.set(i++, de);
                GenPolynomial<BigInteger> spi = PolyUtil.integerFromModularCoefficients(ifac, dm);
                supi.add(spi);
            }
            E = E.subtract((Iterable<BigInteger>)Bi.multiply((BigInteger)((Object)((GenPolynomial)supi.get(0)))));
            if ((E = E.subtract((Iterable<BigInteger>)Ai.multiply((BigInteger)((Object)((GenPolynomial)supi.get(1)))))).isZERO()) {
                return sup;
            }
            Ep = PolyUtil.fromIntegerCoefficients(pkfac, E);
            if (Ep.isZERO()) {
                return sup;
            }
            ++e;
        }
        return sup;
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> A, GenPolynomial<MOD> C, List<MOD> V, long d, long k) throws NoLiftingException {
        void var31_50;
        void var28_41;
        GenPolynomial<BigInteger> genPolynomial;
        GenPolynomialRing pkfac = C.ring;
        if (pkfac.nvar == 1) {
            return HenselUtil.liftDiophant(A, C, k);
        }
        if (!pkfac.equals(A.get((int)0).ring)) {
            throw new IllegalArgumentException("A.ring != pkfac: " + A.get((int)0).ring + " != " + pkfac);
        }
        GenPolynomial<GenPolynomial<MOD>> As = pkfac.getONE();
        for (GenPolynomial<MOD> genPolynomial2 : A) {
            As = As.multiply(genPolynomial2);
        }
        ArrayList<GenPolynomial<GenPolynomial<MOD>>> Bp = new ArrayList<GenPolynomial<GenPolynomial<MOD>>>(A.size());
        for (GenPolynomial<MOD> genPolynomial3 : A) {
            GenPolynomial<GenPolynomial<MOD>> b = PolyUtil.basePseudoDivide(As, genPolynomial3);
            Bp.add(b);
        }
        ArrayList<MOD> arrayList = new ArrayList<MOD>(V);
        GcdRingElem gcdRingElem = (GcdRingElem)arrayList.remove(arrayList.size() - 1);
        GenPolynomial mon = pkfac.getONE();
        GenPolynomial<Element> xv = pkfac.univariate(0, 1L);
        xv = xv.subtract(pkfac.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal()));
        ModularRingFactory cf = (ModularRingFactory)pkfac.coFac;
        GcdRingElem vp = (GcdRingElem)cf.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal());
        GenPolynomialRing ckfac = pkfac.contract(1);
        ArrayList<GenPolynomial<MOD>> Ap = new ArrayList<GenPolynomial<MOD>>(A.size());
        for (GenPolynomial<MOD> a : A) {
            GenPolynomial<GcdRingElem> ap = PolyUtil.evaluateMain(ckfac, a, vp);
            Ap.add(ap);
        }
        GenPolynomial<GcdRingElem> Cp = PolyUtil.evaluateMain(ckfac, C, vp);
        List su = HenselMultUtil.liftDiophant(Ap, Cp, arrayList, d, k);
        if (pkfac.nvar != 2 || !HenselUtil.isDiophantLift(Ap, su, Cp)) {
            // empty if block
        }
        if (!ckfac.equals(su.get((int)0).ring)) {
            throw new IllegalArgumentException("qfac != ckfac: " + su.get((int)0).ring + " != " + ckfac);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pkfac);
        String[] mn = new String[]{pkfac.getVars()[pkfac.nvar - 1]};
        GenPolynomialRing qrfac = new GenPolynomialRing(ckfac, 1, mn);
        ArrayList<GenPolynomial<MOD>> sup = new ArrayList<GenPolynomial<MOD>>(su.size());
        ArrayList<GenPolynomial<BigInteger>> supi = new ArrayList<GenPolynomial<BigInteger>>(su.size());
        for (GenPolynomial genPolynomial4 : su) {
            GenPolynomial genPolynomial5 = genPolynomial4.extend(pkfac, 0, 0L);
            sup.add(genPolynomial5);
            GenPolynomial<BigInteger> genPolynomial6 = PolyUtil.integerFromModularCoefficients(ifac, genPolynomial5);
            supi.add(genPolynomial6);
        }
        ArrayList<GenPolynomial<BigInteger>> Ai = new ArrayList<GenPolynomial<BigInteger>>(A.size());
        for (GenPolynomial<MOD> genPolynomial7 : A) {
            GenPolynomial<BigInteger> genPolynomial8 = PolyUtil.integerFromModularCoefficients(ifac, genPolynomial7);
            Ai.add(genPolynomial8);
        }
        ArrayList<GenPolynomial<BigInteger>> arrayList2 = new ArrayList<GenPolynomial<BigInteger>>(A.size());
        for (GenPolynomial genPolynomial9 : Bp) {
            GenPolynomial<BigInteger> bi = PolyUtil.integerFromModularCoefficients(ifac, genPolynomial9);
            arrayList2.add(bi);
        }
        GenPolynomial<BigInteger> genPolynomial10 = genPolynomial = PolyUtil.integerFromModularCoefficients(ifac, C);
        int i = 0;
        for (GenPolynomial genPolynomial11 : arrayList2) {
            GenPolynomial<GenPolynomial<GenPolynomial>> genPolynomial12 = var28_41.subtract(genPolynomial11.multiply((GenPolynomial)supi.get(i++)));
        }
        if (var28_41.isZERO()) {
            return sup;
        }
        GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pkfac, (GenPolynomial<BigInteger>)var28_41);
        if (Ep.isZERO()) {
            return sup;
        }
        boolean bl = true;
        while ((long)var31_50 <= d) {
            Element vq;
            UnivPowerSeriesRing<GenPolynomial<Element>> psfac = new UnivPowerSeriesRing<GenPolynomial<Element>>(qrfac);
            GenPolynomial Epr = PolyUtil.recursive(qrfac, Ep);
            PolynomialTaylorFunction F = new PolynomialTaylorFunction(Epr);
            UnivPowerSeries<Element> Epst = psfac.seriesOfTaylor(F, (GenPolynomial<Element>)(vq = ckfac.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal())));
            GenPolynomial cm = (GenPolynomial)Epst.coefficient((int)var31_50);
            if (!cm.isZERO()) {
                void var28_43;
                List<GenPolynomial<MOD>> S = HenselMultUtil.liftDiophant(Ap, cm, arrayList, d, k);
                if (!ckfac.coFac.equals(S.get((int)0).ring.coFac)) {
                    throw new IllegalArgumentException("ckfac != pkfac: " + ckfac.coFac + " != " + S.get((int)0).ring.coFac);
                }
                if (pkfac.nvar != 2 || !HenselUtil.isDiophantLift(Ap, S, cm)) {
                    // empty if block
                }
                mon = mon.multiply(xv);
                i = 0;
                supi = new ArrayList(su.size());
                for (GenPolynomial<MOD> genPolynomial13 : S) {
                    GenPolynomial<Object> de = genPolynomial13.extend(pkfac, 0, 0L);
                    GenPolynomial dm = de.multiply((MOD)mon);
                    de = ((GenPolynomial)sup.get(i)).sum(dm);
                    sup.set(i++, de);
                    GenPolynomial<BigInteger> spi = PolyUtil.integerFromModularCoefficients(ifac, dm);
                    supi.add(spi);
                }
                i = 0;
                for (GenPolynomial<Object> genPolynomial14 : arrayList2) {
                    GenPolynomial<GenPolynomial<Object>> genPolynomial15 = var28_43.subtract(genPolynomial14.multiply((Object)((GenPolynomial)supi.get(i++))));
                }
                if (var28_43.isZERO()) {
                    return sup;
                }
                Ep = PolyUtil.fromIntegerCoefficients(pkfac, (GenPolynomial<BigInteger>)var28_43);
                if (Ep.isZERO()) {
                    return sup;
                }
            }
            ++var31_50;
        }
        return sup;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHensel(GenPolynomial<BigInteger> C, GenPolynomial<MOD> Cp, List<GenPolynomial<MOD>> F, List<MOD> V, long k, List<GenPolynomial<BigInteger>> G) throws NoLiftingException {
        GenPolynomialRing pkfac = Cp.ring;
        long d = C.degree();
        GenPolynomialRing pkfac1 = new GenPolynomialRing(pkfac.coFac, G.get((int)0).ring);
        ArrayList Lp = new ArrayList(G.size());
        for (GenPolynomial<BigInteger> cd1 : G) {
            GenPolynomial cdq = PolyUtil.fromIntegerCoefficients(pkfac1, cd1);
            cdq = cdq.extendLower(pkfac, 0, 0L);
            Lp.add(cdq);
        }
        ArrayList<GenPolynomialRing> Pfac = new ArrayList<GenPolynomialRing>();
        ArrayList<GenPolynomial> Ap = new ArrayList<GenPolynomial>();
        ArrayList Gp = new ArrayList();
        ArrayList<GcdRingElem<Object>> Vb = new ArrayList<GcdRingElem<Object>>();
        Pfac.add(pkfac);
        Ap.add(Cp);
        Gp.add(Lp);
        GenPolynomialRing pf = pkfac;
        GenPolynomial ap = Cp;
        List Lpp = Lp;
        for (int j = pkfac.nvar; j > 2; --j) {
            pf = pf.contract(1);
            Pfac.add(0, pf);
            GcdRingElem vp = (GcdRingElem)pkfac.coFac.fromInteger(((Modular)((Object)((GcdRingElem)V.get(pkfac.nvar - j)))).getSymmetricInteger().getVal());
            Vb.add(vp);
            ap = PolyUtil.evaluateMain(pf, ap, vp);
            Ap.add(0, ap);
            ArrayList<GenPolynomial<GcdRingElem>> Lps = new ArrayList<GenPolynomial<GcdRingElem>>(Lpp.size());
            for (GenPolynomial qp : Lpp) {
                GenPolynomial<GcdRingElem> qpe = PolyUtil.evaluateMain(pf, qp, vp);
                Lps.add(qpe);
            }
            Lpp = Lps;
            Gp.add(0, Lpp);
        }
        Vb.add((GcdRingElem<Object>)V.get(pkfac.nvar - 2));
        GenPolynomialRing pk1fac = F.get((int)0).ring;
        if (!pkfac.coFac.equals(pk1fac.coFac)) {
            throw new IllegalArgumentException("F.ring != pkfac: " + pk1fac + " != " + pkfac);
        }
        List<GenPolynomial<MOD>> U = F;
        MonoidElem<GenPolynomial<Object>> E = C.ring.getZERO();
        ArrayList<GcdRingElem> Vh = new ArrayList<GcdRingElem>();
        GcdRingElem v = null;
        while (Pfac.size() > 0) {
            pkfac = (GenPolynomialRing)Pfac.remove(0);
            Cp = (GenPolynomial)Ap.remove(0);
            Lpp = (List)Gp.remove(0);
            v = (GcdRingElem)Vb.remove(Vb.size() - 1);
            List<GenPolynomial<MOD>> U1 = U;
            U = new ArrayList<GenPolynomial<MOD>>(U1.size());
            int j = 0;
            for (GenPolynomial<MOD> b : U1) {
                GenPolynomial<Object> bi = b.extend(pkfac, 0, 0L);
                GenPolynomial li = (GenPolynomial)Lpp.get(j);
                if (!li.isONE()) {
                    GenPolynomialRing pkrfac = pkfac.recursive(pkfac.nvar - 1);
                    GenPolynomial br = PolyUtil.recursive(pkrfac, bi);
                    GenPolynomial bs = PolyUtil.switchVariables(br);
                    GenPolynomial lr = PolyUtil.recursive(pkrfac, li);
                    GenPolynomial genPolynomial = PolyUtil.switchVariables(lr);
                    if (!genPolynomial.isConstant()) {
                        throw new RuntimeException("ls not constant " + genPolynomial);
                    }
                    bs.doPutToMap(bs.leadingExpVector(), genPolynomial.leadingBaseCoefficient());
                    br = PolyUtil.switchVariables(bs);
                    bi = PolyUtil.distribute(pkfac, br);
                }
                U.add(bi);
                ++j;
            }
            GenPolynomial mon = pkfac.getONE();
            GenPolynomial<Element> xv = pkfac.univariate(0, 1L);
            xv = xv.subtract(pkfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal()));
            long deg = Cp.degree(pkfac.nvar - 1);
            GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pkfac);
            List<GenPolynomial<BigInteger>> Bi = PolyUtil.integerFromModularCoefficients(ifac, U);
            GenPolynomial<BigInteger> Ci = PolyUtil.integerFromModularCoefficients(ifac, Cp);
            E = ifac.getONE();
            for (GenPolynomial genPolynomial : Bi) {
                E = ((GenPolynomial)E).multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)genPolynomial))));
            }
            E = Ci.subtract((BigInteger)E);
            GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pkfac, E);
            GenPolynomialRing genPolynomialRing = pkfac.recursive(1);
            GenPolynomialRing ckfac = (GenPolynomialRing)genPolynomialRing.coFac;
            int e = 1;
            while ((long)e <= deg && !Ep.isZERO()) {
                Element vq;
                UnivPowerSeriesRing<GenPolynomial<Element>> univPowerSeriesRing = new UnivPowerSeriesRing<GenPolynomial<Element>>(genPolynomialRing);
                GenPolynomial Epr = PolyUtil.recursive(genPolynomialRing, Ep);
                PolynomialTaylorFunction T = new PolynomialTaylorFunction(Epr);
                UnivPowerSeries<Element> Epst = univPowerSeriesRing.seriesOfTaylor(T, (GenPolynomial<Element>)(vq = ckfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal())));
                GenPolynomial cm = (GenPolynomial)Epst.coefficient(e);
                if (!cm.isZERO()) {
                    List<GenPolynomial<MOD>> Ud = HenselMultUtil.liftDiophant(U1, cm, Vh, d, k);
                    mon = mon.multiply(xv);
                    int i = 0;
                    ArrayList<GenPolynomial<BigInteger>> Si = new ArrayList<GenPolynomial<BigInteger>>(Ud.size());
                    for (GenPolynomial<MOD> genPolynomial : Ud) {
                        GenPolynomial<Object> de = genPolynomial.extend(pkfac, 0, 0L);
                        GenPolynomial dm = de.multiply((MOD)mon);
                        de = U.get(i).sum((MOD)dm);
                        U.set(i++, de);
                        GenPolynomial<BigInteger> si = PolyUtil.integerFromModularCoefficients(ifac, de);
                        Si.add(si);
                    }
                    E = ifac.getONE();
                    for (GenPolynomial<Object> genPolynomial : Si) {
                        E = ((GenPolynomial)E).multiply(genPolynomial);
                    }
                    E = Ci.subtract((BigInteger)E);
                    Ep = PolyUtil.fromIntegerCoefficients(pkfac, E);
                }
                ++e;
            }
            Vh.add(v);
            GenPolynomial Uf = U.get((int)0).ring.getONE();
            for (GenPolynomial genPolynomial : U) {
                Uf = Uf.multiply(genPolynomial);
            }
        }
        if (((GenPolynomial)E).isZERO()) {
            // empty if block
        }
        return U;
    }
}

