/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Complex;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ComplexRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbsolute;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;

public class FactorComplex<C extends GcdRingElem<C>>
extends FactorAbsolute<Complex<C>> {
    public final FactorAbstract<AlgebraicNumber<C>> factorAlgeb;
    public final AlgebraicNumberRing<C> afac;

    public FactorComplex(ComplexRing<C> fac) {
        super(fac);
        this.afac = fac.algebraicRing();
        this.factorAlgeb = FactorFactory.getImplementation(this.afac);
    }

    @Override
    public List<GenPolynomial<Complex<C>>> baseFactorsSquarefree(GenPolynomial<Complex<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<Complex<C>>> factors = new ArrayList<GenPolynomial<Complex<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing cfac = (ComplexRing)pfac.coFac;
        if (!this.afac.ring.coFac.equals(cfac.ring)) {
            throw new IllegalArgumentException("coefficient rings do not match");
        }
        Complex<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        GenPolynomialRing pafac = new GenPolynomialRing(this.afac, pfac);
        GenPolynomial A = PolyUtil.algebraicFromComplex(pafac, P);
        List afactors = this.factorAlgeb.baseFactorsSquarefree(A);
        for (GenPolynomial pa : afactors) {
            GenPolynomial pc = PolyUtil.complexFromAlgebraic(pfac, pa);
            factors.add(pc);
        }
        return factors;
    }
}

