/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbsolute;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.PolyUfdUtil;
import java.util.ArrayList;
import java.util.List;

public class FactorAlgebraic<C extends GcdRingElem<C>>
extends FactorAbsolute<AlgebraicNumber<C>> {
    public final FactorAbstract<C> factorCoeff;

    public FactorAlgebraic(AlgebraicNumberRing<C> fac) {
        this(fac, FactorFactory.getImplementation(fac.ring.coFac));
    }

    public FactorAlgebraic(AlgebraicNumberRing<C> fac, FactorAbstract<C> factorCoeff) {
        super(fac);
        this.factorCoeff = factorCoeff;
    }

    @Override
    public List<GenPolynomial<AlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<AlgebraicNumber<C>> P) {
        List<GenPolynomial<C>> nfacs;
        long k;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> factors = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumber<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        long ks = k = 0L;
        GenPolynomial<C> res = null;
        boolean sqf = false;
        int[] klist = new int[]{0, -1, -2, 1, 2};
        for (int ki = 0; !sqf && ki < klist.length; ++ki) {
            k = klist[ki];
            ks = k;
            res = PolyUfdUtil.norm(P, ks);
            if (res.isZERO() || res.isConstant()) continue;
            sqf = this.factorCoeff.isSquarefree(res);
        }
        if (!sqf) {
            // empty if block
        }
        if ((nfacs = this.factorCoeff.baseFactorsRadical(res)).size() == 1) {
            factors.add(P);
            return factors;
        }
        GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> Pp = P;
        for (GenPolynomial<C> nfi : nfacs) {
            GenPolynomial Ni = PolyUfdUtil.substituteConvertToAlgebraicCoefficients(pfac, nfi, ks);
            GenPolynomial<AlgebraicNumber<C>> pni = this.engine.gcd(Ni, Pp);
            if (!pni.leadingBaseCoefficient().isONE()) {
                pni = pni.monic();
            }
            if (pni.isONE()) continue;
            factors.add(pni);
            Pp = Pp.divide(pni);
        }
        if (!Pp.isZERO() && !Pp.isONE()) {
            factors.add(Pp);
        }
        return factors;
    }
}

