/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public final class TermOrder
implements Serializable {
    public static final int LEX = 1;
    public static final int INVLEX = 2;
    public static final int GRLEX = 3;
    public static final int IGRLEX = 4;
    public static final int REVLEX = 5;
    public static final int REVILEX = 6;
    public static final int REVTDEG = 7;
    public static final int REVITDG = 8;
    public static final int DEFAULT_EVORD = 4;
    private final int evord;
    private final int evord2;
    private final int evbeg1;
    private final int evend1;
    private final int evbeg2;
    private final int evend2;
    private final long[][] weight;
    private final EVComparator horder;
    private final EVComparator lorder;

    public TermOrder() {
        this(4);
    }

    public TermOrder(int evord) {
        if (evord < 1 || 8 < evord) {
            throw new IllegalArgumentException("invalid term order: " + evord);
        }
        this.evord = evord;
        this.evord2 = 0;
        this.weight = null;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = Integer.MAX_VALUE;
        this.evend2 = this.evend1;
        switch (evord) {
            case 1: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return ExpVector.EVILCP(e1, e2);
                    }
                };
                break;
            }
            case 2: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return -ExpVector.EVILCP(e1, e2);
                    }
                };
                break;
            }
            case 3: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return ExpVector.EVIGLC(e1, e2);
                    }
                };
                break;
            }
            case 4: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return -ExpVector.EVIGLC(e1, e2);
                    }
                };
                break;
            }
            case 5: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return ExpVector.EVRILCP(e1, e2);
                    }
                };
                break;
            }
            case 6: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return -ExpVector.EVRILCP(e1, e2);
                    }
                };
                break;
            }
            case 7: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return ExpVector.EVRIGLC(e1, e2);
                    }
                };
                break;
            }
            case 8: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector e1, ExpVector e2) {
                        return -ExpVector.EVRIGLC(e1, e2);
                    }
                };
                break;
            }
            default: {
                this.horder = null;
            }
        }
        if (this.horder == null) {
            throw new IllegalArgumentException("invalid term order: " + evord);
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector e1, ExpVector e2) {
                return -TermOrder.this.horder.compare(e1, e2);
            }
        };
    }

    public TermOrder(long[] w) {
        this(new long[][]{w});
    }

    public TermOrder(long[][] w) {
        if (w == null || w.length == 0) {
            throw new IllegalArgumentException("invalid term order weight");
        }
        this.weight = w;
        this.evord = 0;
        this.evord2 = 0;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = this.weight[0].length;
        this.evend2 = this.evend1;
        this.horder = new EVComparator(){

            @Override
            public int compare(ExpVector e1, ExpVector e2) {
                return -ExpVector.EVIWLC(TermOrder.this.weight, e1, e2);
            }
        };
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector e1, ExpVector e2) {
                return ExpVector.EVIWLC(TermOrder.this.weight, e1, e2);
            }
        };
    }

    public TermOrder(int r, int split) {
        this(4, 4, r, split);
    }

    public TermOrder(int ev1, int ev2, int r, int split) {
        if (ev1 < 1 || 8 < ev1) {
            throw new IllegalArgumentException("invalid term order: " + ev1);
        }
        if (ev2 < 1 || 8 < ev2) {
            throw new IllegalArgumentException("invalid term order: " + ev2);
        }
        this.evord = ev1;
        this.evord2 = ev2;
        this.weight = null;
        this.evbeg1 = 0;
        this.evend1 = split;
        this.evbeg2 = split;
        this.evend2 = r;
        if (this.evbeg2 > this.evend2) {
            throw new IllegalArgumentException("invalid term order split, r = " + r + ", split = " + split);
        }
        block0 : switch (this.evord) {
            case 1: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 2: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 3: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 4: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 5: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 6: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 7: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 8: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRILCP(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector e1, ExpVector e2) {
                                int t = -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (t != 0) {
                                    return t;
                                }
                                return -ExpVector.EVRIGLC(e1, e2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            default: {
                this.horder = null;
            }
        }
        if (this.horder == null) {
            throw new IllegalArgumentException("invalid term order: " + this.evord + " 2 " + this.evord2);
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector e1, ExpVector e2) {
                return -TermOrder.this.horder.compare(e1, e2);
            }
        };
    }

    public int getEvord() {
        return this.evord;
    }

    public int getEvord2() {
        return this.evord2;
    }

    public int getSplit() {
        return this.evend1;
    }

    public long[][] getWeight() {
        return this.weight;
    }

    public EVComparator getDescendComparator() {
        return this.horder;
    }

    public EVComparator getAscendComparator() {
        return this.lorder;
    }

    public boolean equals(Object B) {
        boolean t;
        if (!(B instanceof TermOrder)) {
            return false;
        }
        TermOrder b = (TermOrder)B;
        boolean bl = t = this.evord == b.getEvord() && this.evord2 == b.evord2 && this.evbeg1 == b.evbeg1 && this.evend1 == b.evend1 && this.evbeg2 == b.evbeg2 && this.evend2 == b.evend2;
        if (!t) {
            return t;
        }
        return Arrays.equals((Object[])this.weight, (Object[])b.weight);
    }

    public int hashCode() {
        int h = this.evord;
        h = (h << 3) + this.evord2;
        h = (h << 4) + this.evbeg1;
        h = (h << 4) + this.evend1;
        h = (h << 4) + this.evbeg2;
        h = (h << 4) + this.evend2;
        if (this.weight == null) {
            return h;
        }
        h = h * 7 + Arrays.deepHashCode((Object[])this.weight);
        return h;
    }

    public String toString() {
        StringBuilder erg = new StringBuilder();
        if (this.weight != null) {
            erg.append("W(");
            for (int j = 0; j < this.weight.length; ++j) {
                long[] wj = this.weight[j];
                erg.append("(");
                for (int i = 0; i < wj.length; ++i) {
                    erg.append("").append(wj[wj.length - i - 1]);
                    if (i >= wj.length - 1) continue;
                    erg.append(",");
                }
                erg.append(")");
                if (j >= this.weight.length - 1) continue;
                erg.append(",");
            }
            erg.append(")");
            if (this.evend1 == this.evend2) {
                return erg.toString();
            }
            erg.append("[").append(this.evbeg1).append(",").append(this.evend1).append("]");
            erg.append("[").append(this.evbeg2).append(",").append(this.evend2).append("]");
            return erg.toString();
        }
        switch (this.evord) {
            case 1: {
                erg.append("LEX");
                break;
            }
            case 2: {
                erg.append("INVLEX");
                break;
            }
            case 3: {
                erg.append("GRLEX");
                break;
            }
            case 4: {
                erg.append("IGRLEX");
                break;
            }
            case 5: {
                erg.append("REVLEX");
                break;
            }
            case 6: {
                erg.append("REVILEX");
                break;
            }
            case 7: {
                erg.append("REVTDEG");
                break;
            }
            case 8: {
                erg.append("REVITDG");
                break;
            }
            default: {
                erg.append("invalid(").append(this.evord).append(")");
            }
        }
        if (this.evord2 <= 0) {
            return erg.toString();
        }
        erg.append("[").append(this.evbeg1).append(",").append(this.evend1).append("]");
        switch (this.evord2) {
            case 1: {
                erg.append("LEX");
                break;
            }
            case 2: {
                erg.append("INVLEX");
                break;
            }
            case 3: {
                erg.append("GRLEX");
                break;
            }
            case 4: {
                erg.append("IGRLEX");
                break;
            }
            case 5: {
                erg.append("REVLEX");
                break;
            }
            case 6: {
                erg.append("REVILEX");
                break;
            }
            case 7: {
                erg.append("REVTDEG");
                break;
            }
            case 8: {
                erg.append("REVITDG");
                break;
            }
            default: {
                erg.append("invalid(").append(this.evord2).append(")");
            }
        }
        erg.append("[").append(this.evbeg2).append(",").append(this.evend2).append("]");
        return erg.toString();
    }

    public TermOrder extend(int r, int k) {
        if (this.weight != null) {
            long[][] w = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] wi = this.weight[i];
                long max = 0L;
                for (long aWi : wi) {
                    if (aWi <= max) continue;
                    max = aWi;
                }
                ++max;
                long[] wj = new long[wi.length + k];
                for (int j = 0; j < i; ++j) {
                    wj[j] = max;
                }
                System.arraycopy(wi, 0, wj, i, wi.length);
                w[i] = wj;
            }
            return new TermOrder(w);
        }
        if (this.evord2 != 0) {
            return new TermOrder(this.evord, this.evord2, r + k, this.evend1 + k);
        }
        return new TermOrder(4, this.evord, r + k, k);
    }

    public TermOrder contract(int k, int len) {
        if (this.weight != null) {
            long[][] w = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] wi = this.weight[i];
                long[] wj = new long[len];
                System.arraycopy(wi, k, wj, 0, len);
                w[i] = wj;
            }
            return new TermOrder(w);
        }
        if (this.evord2 == 0) {
            return new TermOrder(this.evord);
        }
        if (this.evend1 > k) {
            int el;
            for (el = this.evend1 - k; el > len; el -= len) {
            }
            if ((long)el == 0L) {
                return new TermOrder(this.evord);
            }
            if (el == len) {
                return new TermOrder(this.evord);
            }
            return new TermOrder(this.evord, this.evord2, len, el);
        }
        return new TermOrder(this.evord2);
    }

    public TermOrder reverse() {
        return this.reverse(false);
    }

    public TermOrder reverse(boolean partial) {
        if (this.weight != null) {
            if (partial) {
                // empty if block
            }
            long[][] w = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] wi = this.weight[i];
                long[] wj = new long[wi.length];
                for (int j = 0; j < wj.length; ++j) {
                    wj[j] = wi[wj.length - 1 - j];
                }
                w[i] = wj;
            }
            TermOrder t = new TermOrder(w);
            return t;
        }
        if (this.evord2 == 0) {
            TermOrder t = new TermOrder(TermOrder.revert(this.evord));
            return t;
        }
        TermOrder t = partial ? new TermOrder(TermOrder.revert(this.evord), TermOrder.revert(this.evord2), this.evend2, this.evend1) : new TermOrder(TermOrder.revert(this.evord2), TermOrder.revert(this.evord), this.evend2, this.evend2 - this.evbeg2);
        return t;
    }

    public static int revert(int evord) {
        int i = evord;
        switch (evord) {
            case 1: {
                i = 5;
                break;
            }
            case 2: {
                i = 6;
                break;
            }
            case 3: {
                i = 7;
                break;
            }
            case 4: {
                i = 8;
                break;
            }
            case 5: {
                i = 1;
                break;
            }
            case 6: {
                i = 2;
                break;
            }
            case 7: {
                i = 3;
                break;
            }
            case 8: {
                i = 4;
                break;
            }
        }
        return i;
    }

    public static abstract class EVComparator
    implements Comparator<ExpVector>,
    Serializable {
        @Override
        public abstract int compare(ExpVector var1, ExpVector var2);
    }
}

