/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;

public final class ExpVectorLong
extends ExpVector {
    final long[] val;

    public ExpVectorLong(int n) {
        this(new long[n]);
    }

    public ExpVectorLong(int n, int i, long e) {
        this(new long[n]);
        this.val[i] = e;
    }

    public ExpVectorLong(long[] v) {
        if (v == null) {
            throw new IllegalArgumentException("null val not allowed");
        }
        this.val = v;
    }

    @Override
    public ExpVectorLong copy() {
        long[] w = new long[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorLong(w);
    }

    @Override
    long[] getVal() {
        return this.val;
    }

    @Override
    public long getVal(int i) {
        return this.val[i];
    }

    @Override
    protected long setVal(int i, long e) {
        long x = this.val[i];
        this.val[i] = e;
        this.hash = 0;
        return x;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorLong extend(int i, int j, long e) {
        long[] w = new long[this.val.length + i];
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[j] = e;
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong extendLower(int i, int j, long e) {
        long[] w = new long[this.val.length + i];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = e;
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        long[] w = new long[len];
        System.arraycopy(this.val, i, w, 0, len);
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong reverse() {
        long[] w = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong reverse(int j) {
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        long[] w = new long[this.val.length];
        for (int i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        System.arraycopy(this.val, j, w, j, this.val.length - j);
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong combine(ExpVector V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorLong Vl = (ExpVectorLong)V;
        if (this.val.length == 0) {
            return Vl;
        }
        long[] w = new long[this.val.length + Vl.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vl.val, 0, w, this.val.length, Vl.val.length);
        return new ExpVectorLong(w);
    }

    @Override
    public String toString() {
        return super.toString() + ":long";
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorLong)) {
            return false;
        }
        ExpVectorLong b = (ExpVectorLong)B;
        int t = this.invLexCompareTo(b);
        return 0 == t;
    }

    @Override
    public ExpVectorLong abs() {
        long[] u = this.val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= 0L ? u[i] : -u[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong negate() {
        long[] u = this.val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = -u[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong sum(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] + v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong subtract(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] - v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong subst(int i, long d) {
        ExpVectorLong V = this.copy();
        return V;
    }

    @Override
    public int signum() {
        long[] u;
        int t = 0;
        for (long anU : u = this.val) {
            if (anU < 0L) {
                return -1;
            }
            if (anU <= 0L) continue;
            t = 1;
        }
        return t;
    }

    @Override
    public long totalDeg() {
        long[] u;
        long t = 0L;
        for (long anU : u = this.val) {
            t += anU;
        }
        return t;
    }

    @Override
    public long maxDeg() {
        long[] u;
        long t = 0L;
        for (long anU : u = this.val) {
            if (anU <= t) continue;
            t = anU;
        }
        return t;
    }

    @Override
    public ExpVectorLong lcm(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong gcd(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public int[] dependencyOnVariables() {
        long[] u = this.val;
        int l = 0;
        for (long anU : u) {
            if (anU <= 0L) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0L) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    @Override
    public boolean multipleOf(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] >= v[i]) continue;
            return false;
        }
        return t;
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    @Override
    public int invLexCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invLexCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < end; ++j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= begin; --j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (long[] wk : w) {
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < u.length; ++j) {
                up += wk[j] * u[j];
                vp += wk[j] * v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }
}

