/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Complex;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.UnaryFunctor;

class ComplToAlgeb<C extends GcdRingElem<C>>
implements UnaryFunctor<Complex<C>, AlgebraicNumber<C>> {
    protected final AlgebraicNumberRing<C> afac;
    protected final AlgebraicNumber<C> I;

    public ComplToAlgeb(AlgebraicNumberRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.afac = fac;
        this.I = this.afac.getGenerator();
    }

    @Override
    public AlgebraicNumber<C> eval(Complex<C> c) {
        if (c == null || c.isZERO()) {
            return this.afac.getZERO();
        }
        if (c.isONE()) {
            return this.afac.getONE();
        }
        if (c.isIMAG()) {
            return this.I;
        }
        return this.I.multiply(c.getIm()).sum(c.getRe());
    }
}

