/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Element;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class AlgebraicNumberRing<C extends RingElem<C>>
implements RingFactory<AlgebraicNumber<C>>,
Iterable<AlgebraicNumber<C>> {
    public final GenPolynomialRing<C> ring;
    public final GenPolynomial<C> modul;
    protected int isField = -1;

    public AlgebraicNumberRing(GenPolynomial<C> m) {
        this.ring = m.ring;
        this.modul = m;
        if (this.ring.nvar > 1) {
            throw new IllegalArgumentException("only univariate polynomials allowed");
        }
    }

    public AlgebraicNumberRing(GenPolynomial<C> m, boolean isField) {
        this.ring = m.ring;
        this.modul = m;
        int n = this.isField = isField ? 1 : 0;
        if (this.ring.nvar > 1) {
            throw new IllegalArgumentException("only univariate polynomials allowed");
        }
    }

    public GenPolynomial<C> getModul() {
        return this.modul;
    }

    @Override
    public AlgebraicNumber<C> copy(AlgebraicNumber<C> c) {
        return new AlgebraicNumber(this, c.val);
    }

    @Override
    public AlgebraicNumber<C> getZERO() {
        return new AlgebraicNumber(this, this.ring.getZERO());
    }

    @Override
    public AlgebraicNumber<C> getONE() {
        return new AlgebraicNumber(this, this.ring.getONE());
    }

    public AlgebraicNumber<C> getGenerator() {
        return new AlgebraicNumber<C>(this, this.ring.univariate(0));
    }

    @Override
    public List<AlgebraicNumber<C>> generators() {
        List<GenPolynomial<C>> gc = this.ring.generators();
        ArrayList<AlgebraicNumber<C>> gens = new ArrayList<AlgebraicNumber<C>>(gc.size());
        for (GenPolynomial<C> g : gc) {
            gens.add(new AlgebraicNumber<C>(this, g));
        }
        return gens;
    }

    @Override
    public boolean isFinite() {
        return this.ring.coFac.isFinite();
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (!this.ring.coFac.isField()) {
            this.isField = 0;
            return false;
        }
        return false;
    }

    public void setField(boolean field) {
        if (this.isField > 0 && field) {
            return;
        }
        if (this.isField == 0 && !field) {
            return;
        }
        this.isField = field ? 1 : 0;
    }

    public int getField() {
        return this.isField;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    public AlgebraicNumber<C> fillFromInteger(BigInteger a) {
        BigInteger q;
        if (this.characteristic().signum() == 0) {
            return new AlgebraicNumber(this, this.ring.fromInteger(a));
        }
        BigInteger p = this.characteristic();
        BigInteger b = a;
        GenPolynomial<GenPolynomial<Element>> v = this.ring.getZERO();
        GenPolynomial<C> x = this.ring.univariate(0, 1L);
        GenPolynomial<GenPolynomial<Element>> t = this.ring.getONE();
        do {
            BigInteger[] qr = b.divideAndRemainder(p);
            q = qr[0];
            BigInteger r = qr[1];
            Element rp = this.ring.fromInteger(r);
            v = v.sum(t.multiply((GenPolynomial<Element>)rp));
            t = t.multiply((GenPolynomial<Element>)x);
        } while (!(b = q).equals(BigInteger.ZERO));
        AlgebraicNumber<GenPolynomial<Element>> an = new AlgebraicNumber<GenPolynomial<Element>>(this, v);
        return an;
    }

    public AlgebraicNumber<C> fillFromInteger(long a) {
        return this.fillFromInteger(new BigInteger("" + a));
    }

    @Override
    public AlgebraicNumber<C> fromInteger(BigInteger a) {
        return new AlgebraicNumber(this, this.ring.fromInteger(a));
    }

    @Override
    public AlgebraicNumber<C> fromInteger(long a) {
        return new AlgebraicNumber(this, this.ring.fromInteger(a));
    }

    public String toString() {
        return "AlgebraicNumberRing[ " + this.modul.toString() + " | isField=" + this.isField + " :: " + this.ring.toString() + " ]";
    }

    public boolean equals(Object b) {
        if (!(b instanceof AlgebraicNumberRing)) {
            return false;
        }
        AlgebraicNumberRing a = null;
        try {
            a = (AlgebraicNumberRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.modul.equals(a.modul);
    }

    public int hashCode() {
        return 37 * this.modul.hashCode() + this.ring.hashCode();
    }

    @Override
    public AlgebraicNumber<C> random(int n) {
        GenPolynomial x = ((GenPolynomial)this.ring.random(n)).monic();
        return new AlgebraicNumber(this, x);
    }

    @Override
    public AlgebraicNumber<C> random(int n, Random rnd) {
        GenPolynomial x = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        return new AlgebraicNumber(this, x);
    }

    public int depth() {
        AlgebraicNumberRing arr = this;
        int depth = 1;
        RingFactory cf = arr.ring.coFac;
        if (cf instanceof AlgebraicNumberRing) {
            arr = (AlgebraicNumberRing)cf;
            depth += arr.depth();
        }
        return depth;
    }

    public long totalExtensionDegree() {
        long degree = this.modul.degree(0);
        AlgebraicNumberRing arr = this;
        RingFactory cf = arr.ring.coFac;
        if (cf instanceof AlgebraicNumberRing) {
            arr = (AlgebraicNumberRing)cf;
            degree = degree == 0L ? arr.totalExtensionDegree() : (degree *= arr.totalExtensionDegree());
        }
        return degree;
    }

    @Override
    public Iterator<AlgebraicNumber<C>> iterator() {
        return new AlgebraicNumberIterator(this);
    }
}

