/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModIntegerRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.Modular;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModularNotInvertibleException;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.NotInvertibleException;

public final class ModInteger
implements GcdRingElem<ModInteger>,
Modular {
    public final ModIntegerRing ring;
    public final java.math.BigInteger val;

    public ModInteger(ModIntegerRing m, java.math.BigInteger a) {
        this.ring = m;
        this.val = a.mod(this.ring.modul);
    }

    public ModInteger(ModIntegerRing m, long a) {
        this(m, new java.math.BigInteger(String.valueOf(a)));
    }

    public ModInteger(ModIntegerRing m, String s) {
        this(m, new java.math.BigInteger(s.trim()));
    }

    public ModInteger(ModIntegerRing m) {
        this(m, java.math.BigInteger.ZERO);
    }

    public java.math.BigInteger getVal() {
        return this.val;
    }

    public ModIntegerRing factory() {
        return this.ring;
    }

    @Override
    public BigInteger getSymmetricInteger() {
        java.math.BigInteger v = this.val;
        if (this.val.add(this.val).compareTo(this.ring.modul) > 0) {
            v = this.val.subtract(this.ring.modul);
        }
        return new BigInteger(v);
    }

    @Override
    public ModInteger copy() {
        return new ModInteger(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val.equals(java.math.BigInteger.ZERO);
    }

    @Override
    public boolean isONE() {
        return this.val.equals(java.math.BigInteger.ONE);
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        java.math.BigInteger g = this.ring.modul.gcd(this.val).abs();
        return g.equals(java.math.BigInteger.ONE);
    }

    public String toString() {
        return this.val.toString();
    }

    @Override
    public int compareTo(ModInteger b) {
        java.math.BigInteger v = b.val;
        if (this.ring != b.ring) {
            v = v.mod(this.ring.modul);
        }
        return this.val.compareTo(v);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof ModInteger)) {
            return false;
        }
        return 0 == this.compareTo((ModInteger)b);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public ModInteger abs() {
        return new ModInteger(this.ring, this.val.abs());
    }

    @Override
    public ModInteger negate() {
        return new ModInteger(this.ring, this.val.negate());
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public ModInteger subtract(ModInteger S) {
        return new ModInteger(this.ring, this.val.subtract(S.val));
    }

    @Override
    public ModInteger divide(ModInteger S) {
        try {
            return this.multiply(S.inverse());
        }
        catch (NotInvertibleException e) {
            try {
                if (this.val.remainder(S.val).equals(java.math.BigInteger.ZERO)) {
                    return new ModInteger(this.ring, this.val.divide(S.val));
                }
                throw new NotInvertibleException(e);
            }
            catch (ArithmeticException a) {
                throw new NotInvertibleException(a);
            }
        }
    }

    @Override
    public ModInteger inverse() {
        try {
            return new ModInteger(this.ring, this.val.modInverse(this.ring.modul));
        }
        catch (ArithmeticException e) {
            java.math.BigInteger g = this.val.gcd(this.ring.modul);
            java.math.BigInteger f = this.ring.modul.divide(g);
            throw new ModularNotInvertibleException(e, (GcdRingElem)new BigInteger(this.ring.modul), (GcdRingElem)new BigInteger(g), (GcdRingElem)new BigInteger(f));
        }
    }

    @Override
    public ModInteger remainder(ModInteger S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (S.isONE()) {
            return this.ring.getZERO();
        }
        if (S.isUnit()) {
            return this.ring.getZERO();
        }
        return new ModInteger(this.ring, this.val.remainder(S.val));
    }

    @Override
    public ModInteger multiply(ModInteger S) {
        return new ModInteger(this.ring, this.val.multiply(S.val));
    }

    @Override
    public ModInteger sum(ModInteger S) {
        return new ModInteger(this.ring, this.val.add(S.val));
    }

    @Override
    public ModInteger gcd(ModInteger S) {
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.isUnit() || S.isUnit()) {
            return this.ring.getONE();
        }
        return new ModInteger(this.ring, this.val.gcd(S.val));
    }

    public ModInteger[] egcd(ModInteger S) {
        ModInteger[] ret = new ModInteger[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.isUnit() || S.isUnit()) {
            ret[0] = this.ring.getONE();
            if (this.isUnit() && S.isUnit()) {
                ret[1] = this.ring.getONE();
                ModInteger x = ret[0].subtract(ret[1].multiply(this));
                ret[2] = x.divide(S);
                return ret;
            }
            if (this.isUnit()) {
                ret[1] = this.inverse();
                ret[2] = this.ring.getZERO();
                return ret;
            }
            ret[1] = this.ring.getZERO();
            ret[2] = S.inverse();
            return ret;
        }
        java.math.BigInteger q = this.val;
        java.math.BigInteger r = S.val;
        java.math.BigInteger c1 = BigInteger.ONE.val;
        java.math.BigInteger d1 = BigInteger.ZERO.val;
        java.math.BigInteger c2 = BigInteger.ZERO.val;
        java.math.BigInteger d2 = BigInteger.ONE.val;
        while (!r.equals(java.math.BigInteger.ZERO)) {
            java.math.BigInteger[] qr = q.divideAndRemainder(r);
            q = qr[0];
            java.math.BigInteger x1 = c1.subtract(q.multiply(d1));
            java.math.BigInteger x2 = c2.subtract(q.multiply(d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        ret[0] = new ModInteger(this.ring, q);
        ret[1] = new ModInteger(this.ring, c1);
        ret[2] = new ModInteger(this.ring, c2);
        return ret;
    }
}

