/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRationalIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRationalUniqueIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class BigRational
implements GcdRingElem<BigRational>,
RingFactory<BigRational>,
Iterable<BigRational> {
    public final java.math.BigInteger num;
    public final java.math.BigInteger den;
    public static final BigRational ZERO = new BigRational(java.math.BigInteger.ZERO);
    public static final BigRational ONE = new BigRational(java.math.BigInteger.ONE);
    private static final Random random = new Random();
    private boolean nonNegative = true;
    private boolean duplicates = true;

    protected BigRational(java.math.BigInteger n, java.math.BigInteger d) {
        this.num = n;
        this.den = d;
    }

    public BigRational(java.math.BigInteger n) {
        this.num = n;
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational(BigInteger n) {
        this(n.getVal());
    }

    public BigRational(BigInteger n, BigInteger d) {
        java.math.BigInteger nu = n.getVal();
        java.math.BigInteger de = d.getVal();
        BigRational r = BigRational.RNRED(nu, de);
        this.num = r.num;
        this.den = r.den;
    }

    public BigRational(long n, long d) {
        java.math.BigInteger nu = java.math.BigInteger.valueOf(n);
        java.math.BigInteger de = java.math.BigInteger.valueOf(d);
        BigRational r = BigRational.RNRED(nu, de);
        this.num = r.num;
        this.den = r.den;
    }

    public BigRational(long n) {
        this.num = java.math.BigInteger.valueOf(n);
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational() {
        this.num = java.math.BigInteger.ZERO;
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational(String s) throws NumberFormatException {
        if (s == null) {
            this.num = java.math.BigInteger.ZERO;
            this.den = java.math.BigInteger.ONE;
            return;
        }
        if (s.length() == 0) {
            this.num = java.math.BigInteger.ZERO;
            this.den = java.math.BigInteger.ONE;
            return;
        }
        int i = (s = s.trim()).indexOf(47);
        if (i < 0) {
            i = s.indexOf(46);
            if (i < 0) {
                this.num = new java.math.BigInteger(s);
                this.den = java.math.BigInteger.ONE;
                return;
            }
            java.math.BigInteger n = s.charAt(0) == '-' ? new java.math.BigInteger(s.substring(1, i)) : new java.math.BigInteger(s.substring(0, i));
            BigRational r = new BigRational(n);
            java.math.BigInteger d = new java.math.BigInteger(s.substring(i + 1, s.length()));
            int j = s.length() - i - 1;
            BigRational z = new BigRational(1L, 10L);
            z = Power.positivePower(z, j);
            BigRational f = new BigRational(d);
            f = f.multiply(z);
            r = r.sum(f);
            this.num = s.charAt(0) == '-' ? r.num.negate() : r.num;
            this.den = r.den;
        } else {
            java.math.BigInteger n = new java.math.BigInteger(s.substring(0, i));
            java.math.BigInteger d = new java.math.BigInteger(s.substring(i + 1, s.length()));
            BigRational r = BigRational.RNRED(n, d);
            this.num = r.num;
            this.den = r.den;
        }
    }

    public BigRational factory() {
        return this;
    }

    @Override
    public List<BigRational> generators() {
        ArrayList<BigRational> g = new ArrayList<BigRational>(1);
        g.add(this.getONE());
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigRational copy() {
        return new BigRational(this.num, this.den);
    }

    @Override
    public BigRational copy(BigRational c) {
        return new BigRational(c.num, c.den);
    }

    public java.math.BigInteger numerator() {
        return this.num;
    }

    public java.math.BigInteger denominator() {
        return this.den;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.num);
        if (!this.den.equals(java.math.BigInteger.ONE)) {
            s.append("/").append(this.den);
        }
        return s.toString();
    }

    @Override
    public BigRational getZERO() {
        return ZERO;
    }

    @Override
    public BigRational getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return java.math.BigInteger.ZERO;
    }

    @Override
    public BigRational fromInteger(java.math.BigInteger a) {
        return new BigRational(a);
    }

    public BigRational fromInteger(BigInteger a) {
        return new BigRational(a);
    }

    public static BigRational valueOf(java.math.BigInteger a) {
        return new BigRational(a);
    }

    @Override
    public BigRational fromInteger(long a) {
        return new BigRational(a);
    }

    public static BigRational valueOf(long a) {
        return new BigRational(a);
    }

    @Override
    public boolean isZERO() {
        return this.num.equals(java.math.BigInteger.ZERO);
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigRational)) {
            return false;
        }
        BigRational br = (BigRational)b;
        return this.num.equals(br.num) && this.den.equals(br.den);
    }

    @Override
    public int hashCode() {
        return 37 * this.num.hashCode() + this.den.hashCode();
    }

    public static BigRational RNRED(java.math.BigInteger n, java.math.BigInteger d) {
        if (n.equals(java.math.BigInteger.ZERO)) {
            java.math.BigInteger num = n;
            java.math.BigInteger den = java.math.BigInteger.ONE;
            return new BigRational(num, den);
        }
        java.math.BigInteger C = n.gcd(d);
        java.math.BigInteger num = n.divide(C);
        java.math.BigInteger den = d.divide(C);
        if (den.signum() < 0) {
            num = num.negate();
            den = den.negate();
        }
        return new BigRational(num, den);
    }

    public static BigRational reduction(java.math.BigInteger n, java.math.BigInteger d) {
        return BigRational.RNRED(n, d);
    }

    @Override
    public BigRational abs() {
        if (this.signum() >= 0) {
            return this;
        }
        return this.negate();
    }

    @Override
    public int compareTo(BigRational S) {
        int SL;
        if (this.equals(ZERO)) {
            return -S.signum();
        }
        if (S.equals(ZERO)) {
            return this.signum();
        }
        java.math.BigInteger R1 = this.num;
        java.math.BigInteger R2 = this.den;
        java.math.BigInteger S1 = S.num;
        java.math.BigInteger S2 = S.den;
        int RL = R1.signum();
        int J1Y = RL - (SL = S1.signum());
        int TL = J1Y / 2;
        if (TL != 0) {
            return TL;
        }
        java.math.BigInteger J3Y = R1.multiply(S2);
        java.math.BigInteger J2Y = R2.multiply(S1);
        TL = J3Y.compareTo(J2Y);
        return TL;
    }

    @Override
    public BigRational subtract(BigRational S) {
        return this.sum(S.negate());
    }

    @Override
    public BigRational inverse() {
        java.math.BigInteger S2;
        java.math.BigInteger S1;
        java.math.BigInteger R1 = this.num;
        java.math.BigInteger R2 = this.den;
        if (R1.signum() >= 0) {
            S1 = R2;
            S2 = R1;
        } else {
            S1 = R2.negate();
            S2 = R1.negate();
        }
        return new BigRational(S1, S2);
    }

    @Override
    public BigRational negate() {
        java.math.BigInteger n = this.num.negate();
        return new BigRational(n, this.den);
    }

    @Override
    public BigRational multiply(BigRational S) {
        if (this.equals(ZERO) || S.equals(ZERO)) {
            BigRational T = ZERO;
            return T;
        }
        java.math.BigInteger R1 = this.num;
        java.math.BigInteger R2 = this.den;
        java.math.BigInteger S1 = S.num;
        java.math.BigInteger S2 = S.den;
        if (R2.equals(java.math.BigInteger.ONE) && S2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R1.multiply(S1);
            BigRational T = new BigRational(T1, java.math.BigInteger.ONE);
            return T;
        }
        if (R2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger D1 = R1.gcd(S2);
            java.math.BigInteger RB1 = R1.divide(D1);
            java.math.BigInteger SB2 = S2.divide(D1);
            java.math.BigInteger T1 = RB1.multiply(S1);
            BigRational T = new BigRational(T1, SB2);
            return T;
        }
        if (S2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger D2 = S1.gcd(R2);
            java.math.BigInteger SB1 = S1.divide(D2);
            java.math.BigInteger RB2 = R2.divide(D2);
            java.math.BigInteger T1 = SB1.multiply(R1);
            BigRational T = new BigRational(T1, RB2);
            return T;
        }
        java.math.BigInteger D1 = R1.gcd(S2);
        java.math.BigInteger RB1 = R1.divide(D1);
        java.math.BigInteger SB2 = S2.divide(D1);
        java.math.BigInteger D2 = S1.gcd(R2);
        java.math.BigInteger SB1 = S1.divide(D2);
        java.math.BigInteger RB2 = R2.divide(D2);
        java.math.BigInteger T1 = RB1.multiply(SB1);
        java.math.BigInteger T2 = RB2.multiply(SB2);
        BigRational T = new BigRational(T1, T2);
        return T;
    }

    @Override
    public BigRational divide(BigRational S) {
        return this.multiply(S.inverse());
    }

    @Override
    public BigRational remainder(BigRational S) {
        if (S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    @Override
    public BigRational random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigRational random(int n, Random rnd) {
        java.math.BigInteger A = new java.math.BigInteger(n, rnd);
        if (rnd.nextBoolean()) {
            A = A.negate();
        }
        java.math.BigInteger B = new java.math.BigInteger(n, rnd);
        B = B.add(java.math.BigInteger.ONE);
        return BigRational.RNRED(A, B);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public BigRational sum(BigRational S) {
        java.math.BigInteger E;
        java.math.BigInteger J2Y;
        if (this.equals(ZERO)) {
            BigRational T = S;
            return T;
        }
        if (S.equals(ZERO)) {
            BigRational T = this;
            return T;
        }
        java.math.BigInteger R1 = this.num;
        java.math.BigInteger R2 = this.den;
        java.math.BigInteger S1 = S.num;
        java.math.BigInteger S2 = S.den;
        if (R2.equals(java.math.BigInteger.ONE) && S2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R1.add(S1);
            BigRational T = new BigRational(T1, java.math.BigInteger.ONE);
            return T;
        }
        if (R2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R1.multiply(S2);
            T1 = T1.add(S1);
            BigRational T = new BigRational(T1, S2);
            return T;
        }
        if (S2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R2.multiply(S1);
            T1 = T1.add(R1);
            BigRational T = new BigRational(T1, R2);
            return T;
        }
        java.math.BigInteger D = R2.gcd(S2);
        java.math.BigInteger RB2 = R2.divide(D);
        java.math.BigInteger SB2 = S2.divide(D);
        java.math.BigInteger J1Y = R1.multiply(SB2);
        java.math.BigInteger T1 = J1Y.add(J2Y = RB2.multiply(S1));
        if (T1.equals(java.math.BigInteger.ZERO)) {
            BigRational T = ZERO;
            return T;
        }
        if (!D.equals(java.math.BigInteger.ONE) && !(E = T1.gcd(D)).equals(java.math.BigInteger.ONE)) {
            T1 = T1.divide(E);
            R2 = R2.divide(E);
        }
        java.math.BigInteger T2 = R2.multiply(SB2);
        BigRational T = new BigRational(T1, T2);
        return T;
    }

    @Override
    public BigRational gcd(BigRational S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        return ONE;
    }

    public BigRational[] egcd(BigRational S) {
        BigRational[] ret = new BigRational[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        BigRational half = new BigRational(1L, 2L);
        ret[0] = ONE;
        ret[1] = this.inverse().multiply(half);
        ret[2] = S.inverse().multiply(half);
        return ret;
    }

    @Override
    public Iterator<BigRational> iterator() {
        if (this.duplicates) {
            return new BigRationalIterator(this.nonNegative);
        }
        return new BigRationalUniqueIterator(new BigRationalIterator(this.nonNegative));
    }
}

