/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.expand;

import cc.redberry.core.combinatorics.IntTuplesPort;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.transformations.expand.ExpandUtils;
import cc.redberry.core.utils.OutputPort;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.set.hash.TIntHashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public final class ExpandPort {
    public static Tensor expandUsingPort(Tensor t) {
        Tensor n;
        SumBuilder sb = new SumBuilder();
        OutputPort<Tensor> port = ExpandPort.createPort(t);
        while ((n = port.take()) != null) {
            sb.put(n);
        }
        return sb.build();
    }

    public static OutputPort<Tensor> createPort(Tensor tensor) {
        if (tensor instanceof Product) {
            return new ProductPort(tensor);
        }
        if (tensor instanceof Sum) {
            return new SumPort(tensor);
        }
        if (ExpandUtils.isExpandablePower(tensor) && !TensorUtils.isNegativeNaturalNumber(tensor.get(1))) {
            return new PowerPort(tensor);
        }
        return new OutputPort.Singleton<Tensor>(tensor);
    }

    private static final class SumPort
    implements ResettablePort {
        private final OutputPort<Tensor>[] ports;
        private final Tensor tensor;
        private int pointer;

        public SumPort(Tensor tensor) {
            this.tensor = tensor;
            this.ports = new OutputPort[tensor.size()];
            this.reset();
        }

        @Override
        public void reset() {
            this.pointer = 0;
            for (int i = this.tensor.size() - 1; i >= 0; --i) {
                this.ports[i] = ExpandPort.createPort(this.tensor.get(i));
            }
        }

        @Override
        public Tensor take() {
            Tensor t = null;
            while (this.pointer < this.tensor.size()) {
                t = this.ports[this.pointer].take();
                if (t == null) {
                    ++this.pointer;
                    continue;
                }
                return t;
            }
            return t;
        }
    }

    private static final class ProductPort
    implements OutputPort<Tensor> {
        private final ProductBuilder base;
        private ProductBuilder currentBuilder;
        private final ResettablePort[] sumsAndPowers;
        private final Tensor[] currentMultipliers;
        private final Tensor tensor;

        public ProductPort(Tensor tensor) {
            this.tensor = tensor;
            this.base = new ProductBuilder();
            ArrayList<ResettablePort> sumOrPowerPorts = new ArrayList<ResettablePort>();
            int theLargestSumPosition = 0;
            int theLargestSumSize = 0;
            int productSize = tensor.size();
            for (int i = 0; i < productSize; ++i) {
                Tensor m = tensor.get(i);
                if (m instanceof Sum) {
                    if (m.size() > theLargestSumSize) {
                        theLargestSumPosition = sumOrPowerPorts.size();
                        theLargestSumSize = m.size();
                    }
                    sumOrPowerPorts.add(new SumPort(m));
                    continue;
                }
                if (ExpandUtils.isExpandablePower(m)) {
                    if (TensorUtils.isNegativeNaturalNumber(m.get(1))) {
                        this.base.put(m);
                        continue;
                    }
                    if (NumberUtils.pow(BigInteger.valueOf(m.get(0).size()), ((Complex)m.get(1)).getReal().bigIntValue()).compareTo(BigInteger.valueOf(theLargestSumSize)) > 0) {
                        theLargestSumPosition = sumOrPowerPorts.size();
                        theLargestSumSize = m.size();
                    }
                    sumOrPowerPorts.add(new PowerPort(m, TensorUtils.getAllIndicesNamesT(tensor).toArray()));
                    continue;
                }
                this.base.put(m);
            }
            this.sumsAndPowers = sumOrPowerPorts.toArray(new ResettablePort[sumOrPowerPorts.size()]);
            if (this.sumsAndPowers.length <= 1) {
                this.currentMultipliers = new Tensor[0];
                this.currentBuilder = this.base;
            } else {
                ResettablePort temp = this.sumsAndPowers[theLargestSumPosition];
                this.sumsAndPowers[theLargestSumPosition] = this.sumsAndPowers[this.sumsAndPowers.length - 1];
                this.sumsAndPowers[this.sumsAndPowers.length - 1] = temp;
                this.currentMultipliers = new Tensor[this.sumsAndPowers.length - 2];
                for (productSize = 0; productSize < this.sumsAndPowers.length - 2; ++productSize) {
                    this.currentMultipliers[productSize] = (Tensor)this.sumsAndPowers[productSize].take();
                }
                this.currentBuilder = this.nextCombination();
            }
        }

        private ProductBuilder nextCombination() {
            if (this.sumsAndPowers.length == 1) {
                return null;
            }
            int pointer = this.sumsAndPowers.length - 2;
            ProductBuilder temp = this.base.clone();
            boolean next = false;
            Tensor c = (Tensor)this.sumsAndPowers[pointer].take();
            if (c == null) {
                this.sumsAndPowers[pointer].reset();
                c = (Tensor)this.sumsAndPowers[pointer].take();
                next = true;
            }
            temp.put(c);
            while (--pointer >= 0) {
                if (next) {
                    next = false;
                    c = (Tensor)this.sumsAndPowers[pointer].take();
                    if (c == null) {
                        this.sumsAndPowers[pointer].reset();
                        c = (Tensor)this.sumsAndPowers[pointer].take();
                        next = true;
                    }
                    this.currentMultipliers[pointer] = c;
                }
                temp.put(this.currentMultipliers[pointer]);
            }
            if (next) {
                return null;
            }
            return temp;
        }

        @Override
        public Tensor take() {
            if (this.currentBuilder == null) {
                return null;
            }
            if (this.sumsAndPowers.length == 0) {
                this.currentBuilder = null;
                return this.tensor;
            }
            Tensor t = (Tensor)this.sumsAndPowers[this.sumsAndPowers.length - 1].take();
            if (t == null) {
                this.currentBuilder = this.nextCombination();
                this.sumsAndPowers[this.sumsAndPowers.length - 1].reset();
                return this.take();
            }
            ProductBuilder temp = this.currentBuilder.clone();
            temp.put(t);
            return temp.build();
        }
    }

    private static final class PowerPort
    implements ResettablePort {
        private final Tensor base;
        private final int power;
        private IntTuplesPort tuplesPort;
        private final int[] initialForbidden;
        private OutputPort<Tensor> currentPort;

        public PowerPort(Tensor tensor, int[] initialForbidden) {
            this.base = tensor.get(0);
            this.power = ((Complex)tensor.get(1)).getReal().intValue();
            int[] upperBounds = new int[this.power];
            Arrays.fill(upperBounds, this.base.size());
            this.tuplesPort = new IntTuplesPort(upperBounds);
            this.initialForbidden = initialForbidden;
            this.currentPort = this.nextPort();
        }

        public PowerPort(Tensor tensor) {
            this(tensor, TensorUtils.getAllIndicesNamesT(tensor.get(0)).toArray());
        }

        OutputPort<Tensor> nextPort() {
            int[] tuple = this.tuplesPort.take();
            if (tuple == null) {
                return null;
            }
            TIntHashSet added = new TIntHashSet(this.initialForbidden);
            ProductBuilder builder = new ProductBuilder();
            builder.put(this.base.get(tuple[0]));
            for (int i = 1; i < tuple.length; ++i) {
                builder.put(ApplyIndexMapping.renameDummy(this.base.get(tuple[i]), added.toArray(), added));
            }
            return ExpandPort.createPort(builder.build());
        }

        @Override
        public Tensor take() {
            if (this.currentPort == null) {
                return null;
            }
            Tensor t = this.currentPort.take();
            if (t == null) {
                this.currentPort = this.nextPort();
                return this.take();
            }
            return t;
        }

        @Override
        public void reset() {
            this.tuplesPort.reset();
            this.currentPort = this.nextPort();
        }
    }

    private static interface ResettablePort
    extends OutputPort<Tensor> {
        public void reset();
    }
}

