/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.expand;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.AbstractExpandNumeratorDenominatorTransformation;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.transformations.fractions.NumeratorDenominator;

public final class ExpandNumeratorTransformation
extends AbstractExpandNumeratorDenominatorTransformation {
    public static final ExpandNumeratorTransformation EXPAND_NUMERATOR = new ExpandNumeratorTransformation();

    private ExpandNumeratorTransformation() {
    }

    public ExpandNumeratorTransformation(Transformation[] transformations) {
        super(transformations);
    }

    public static Tensor expandNumerator(Tensor tensor) {
        return EXPAND_NUMERATOR.transform(tensor);
    }

    public static Tensor expandNumerator(Tensor tensor, Transformation ... transformations) {
        return new ExpandNumeratorTransformation(transformations).transform(tensor);
    }

    @Override
    protected Tensor expandProduct(Tensor product) {
        NumeratorDenominator numDen = NumeratorDenominator.getNumeratorAndDenominator(product, NumeratorDenominator.integerDenominatorIndicator);
        Tensor numerator = ExpandTransformation.expand(numDen.numerator, this.transformations);
        if (numDen.numerator == numerator) {
            return product;
        }
        return Tensors.multiply(numerator, Tensors.reciprocal(numDen.denominator));
    }
}

