/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.expand;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.AbstractExpandNumeratorDenominatorTransformation;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.transformations.fractions.NumeratorDenominator;

public final class ExpandDenominatorTransformation
extends AbstractExpandNumeratorDenominatorTransformation {
    public static final ExpandDenominatorTransformation EXPAND_DENOMINATOR = new ExpandDenominatorTransformation();

    public ExpandDenominatorTransformation(Transformation[] transformations) {
        super(transformations);
    }

    private ExpandDenominatorTransformation() {
    }

    public static Tensor expandDenominator(Tensor tensor) {
        return EXPAND_DENOMINATOR.transform(tensor);
    }

    public static Tensor expandDenominator(Tensor tensor, Transformation ... transformations) {
        return new ExpandDenominatorTransformation(transformations).transform(tensor);
    }

    @Override
    protected Tensor expandProduct(Tensor product) {
        NumeratorDenominator numDen = NumeratorDenominator.getNumeratorAndDenominator(product, NumeratorDenominator.integerDenominatorIndicator);
        Tensor denominator = ExpandTransformation.expand(numDen.denominator, this.transformations);
        if (numDen.denominator == denominator) {
            return product;
        }
        return Tensors.multiply(numDen.numerator, Tensors.reciprocal(denominator));
    }
}

