/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.expand;

import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.iterator.TraverseGuide;
import cc.redberry.core.tensor.iterator.TraversePermission;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.ExpandUtils;
import cc.redberry.core.transformations.substitutions.SubstitutionIterator;
import cc.redberry.core.utils.TensorUtils;

abstract class AbstractExpandTransformation
implements Transformation {
    public static TraverseGuide DefaultExpandTraverseGuide = new TraverseGuide(){

        @Override
        public TraversePermission getPermission(Tensor tensor, Tensor parent, int indexInParent) {
            if (tensor instanceof ScalarFunction) {
                return TraversePermission.DontShow;
            }
            if (tensor instanceof TensorField) {
                return TraversePermission.DontShow;
            }
            if (TensorUtils.isNegativeIntegerPower(tensor)) {
                return TraversePermission.DontShow;
            }
            return TraversePermission.Enter;
        }
    };
    protected final Transformation[] transformations;
    protected final TraverseGuide traverseGuide;

    protected AbstractExpandTransformation() {
        this(new Transformation[0], DefaultExpandTraverseGuide);
    }

    protected AbstractExpandTransformation(Transformation[] transformations) {
        this(transformations, DefaultExpandTraverseGuide);
    }

    protected AbstractExpandTransformation(Transformation[] transformations, TraverseGuide traverseGuide) {
        this.transformations = transformations;
        this.traverseGuide = traverseGuide;
    }

    @Override
    public Tensor transform(Tensor tensor) {
        Tensor current;
        SubstitutionIterator iterator = new SubstitutionIterator(tensor, this.traverseGuide);
        while ((current = iterator.next()) != null) {
            if (current instanceof Product) {
                iterator.unsafeSet(this.expandProduct((Product)current, this.transformations));
                continue;
            }
            if (!ExpandUtils.isExpandablePower(current)) continue;
            Sum sum = (Sum)current.get(0);
            int exponent = ((Complex)current.get(1)).intValue();
            if (exponent == -1) continue;
            boolean symbolic = TensorUtils.isSymbolic((Tensor)sum);
            boolean reciprocal = exponent < 0;
            exponent = Math.abs(exponent);
            Tensor temp = symbolic ? ExpandUtils.expandSymbolicPower(sum, exponent, this.transformations) : ExpandUtils.expandPower(sum, exponent, iterator.getForbidden(), this.transformations);
            if (reciprocal) {
                temp = Tensors.reciprocal(temp);
            }
            if (symbolic) {
                iterator.unsafeSet(temp);
                continue;
            }
            iterator.set(temp);
        }
        return iterator.result();
    }

    protected abstract Tensor expandProduct(Product var1, Transformation[] var2);
}

