/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.iterator;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.iterator.TraversePermission;

public interface TraverseGuide {
    public static final TraverseGuide ALL = new TraverseGuide(){

        @Override
        public TraversePermission getPermission(Tensor tensor, Tensor parent, int indexInParent) {
            return TraversePermission.Enter;
        }
    };
    public static final TraverseGuide EXCEPT_FUNCTIONS_AND_FIELDS = new TraverseGuide(){

        @Override
        public TraversePermission getPermission(Tensor tensor, Tensor parent, int indexInParent) {
            if (tensor instanceof ScalarFunction) {
                return TraversePermission.DontShow;
            }
            if (tensor instanceof TensorField) {
                return TraversePermission.ShowButNotEnter;
            }
            return TraversePermission.Enter;
        }
    };
    public static final TraverseGuide EXCEPT_FIELDS = new TraverseGuide(){

        @Override
        public TraversePermission getPermission(Tensor tensor, Tensor parent, int indexInParent) {
            if (tensor instanceof TensorField) {
                return TraversePermission.ShowButNotEnter;
            }
            return TraversePermission.Enter;
        }
    };

    public TraversePermission getPermission(Tensor var1, Tensor var2, int var3);
}

