/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.utils.TensorUtils;

class ScalarFunctionBuilder
implements TensorBuilder {
    private final ScalarFunctionFactory factory;
    private Tensor arg;

    ScalarFunctionBuilder(ScalarFunctionFactory factory) {
        this.factory = factory;
    }

    ScalarFunctionBuilder(ScalarFunctionFactory factory, Tensor arg) {
        this.factory = factory;
        this.arg = arg;
    }

    @Override
    public Tensor build() {
        return this.factory.create1(this.arg);
    }

    @Override
    public void put(Tensor tensor) {
        if (this.arg != null) {
            throw new IllegalStateException();
        }
        if (tensor == null) {
            throw new NullPointerException();
        }
        if (!TensorUtils.isScalar(tensor)) {
            throw new IllegalArgumentException();
        }
        this.arg = tensor;
    }

    @Override
    public TensorBuilder clone() {
        return new ScalarFunctionBuilder(this.factory, this.arg);
    }
}

