/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.Cot;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.utils.TensorUtils;

public class ArcCot
extends ScalarFunction {
    ArcCot(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.multiply(Tensors.pow(Tensors.sum(Complex.ONE, Tensors.pow(this.argument, Complex.TWO)), Complex.MINUS_ONE), Complex.MINUS_ONE);
    }

    @Override
    protected String functionName() {
        return "ArcCot";
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(ArcCotFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return ArcCotFactory.FACTORY;
    }

    @Override
    protected int hash() {
        return 2311 * this.argument.hashCode();
    }

    public static final class ArcCotFactory
    extends ScalarFunctionFactory {
        public static final ArcCotFactory FACTORY = new ArcCotFactory();

        private ArcCotFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof Cot) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Tensors.parse("pi/2");
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.arccot((Complex)arg);
            }
            return new ArcCot(arg);
        }
    }
}

