/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.Cos;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.utils.TensorUtils;

public class ArcCos
extends ScalarFunction {
    ArcCos(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.multiply(Tensors.pow(Tensors.sum(Complex.ONE, Tensors.pow(this.argument, Complex.TWO)), Complex.MINUS_ONE_HALF), Complex.MINUS_ONE);
    }

    @Override
    protected String functionName() {
        return "ArcCos";
    }

    @Override
    protected int hash() {
        return 92841 * this.argument.hashCode();
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(ArcCosFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return ArcCosFactory.FACTORY;
    }

    public static final class ArcCosFactory
    extends ScalarFunctionFactory {
        public static final ArcCosFactory FACTORY = new ArcCosFactory();

        private ArcCosFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof Cos) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Tensors.parse("pi/2");
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.arccos((Complex)arg);
            }
            return new ArcCos(arg);
        }
    }
}

