/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.utils.HashFunctions;
import java.util.Arrays;

public final class TensorContraction
implements Comparable<TensorContraction> {
    public final short tensorId;
    public final long[] indexContractions;
    private int hash = -1;

    public TensorContraction(short tensorId, long[] indexContractions) {
        this.tensorId = tensorId;
        this.indexContractions = indexContractions;
    }

    void sortContractions() {
        Arrays.sort(this.indexContractions);
    }

    public boolean containsFreeIndex() {
        for (long contraction : this.indexContractions) {
            if (TensorContraction.getToTensorId(contraction) != -1) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        TensorContraction other = (TensorContraction)obj;
        if (this.tensorId != other.tensorId) {
            return false;
        }
        return Arrays.equals(this.indexContractions, other.indexContractions);
    }

    public int hashCode() {
        if (this.hash == -1) {
            long hash = 1L;
            for (long l : this.indexContractions) {
                hash ^= HashFunctions.JenkinWang64shift(l);
            }
            this.hash = HashFunctions.Wang64to32shift(hash);
        }
        return this.hash;
    }

    @Override
    public int compareTo(TensorContraction o) {
        int val = Integer.compare(this.tensorId, o.tensorId);
        if (val != 0) {
            return val;
        }
        val = Integer.compare(this.indexContractions.length, o.indexContractions.length);
        if (val != 0) {
            return val;
        }
        for (int i = 0; i < this.indexContractions.length; ++i) {
            val = Long.compare(this.indexContractions[i], o.indexContractions[i]);
            if (val == 0) continue;
            return val;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.indexContractions.length == 0) {
            return builder.append(this.tensorId).append("x").toString();
        }
        builder.append(this.tensorId).append("x{");
        for (long l : this.indexContractions) {
            builder.append("^").append(TensorContraction.getFromIndexId(l)).append("->").append(TensorContraction.getToTensorId(l)).append("^").append(TensorContraction.getToIndexId(l));
            builder.append(":");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        return builder.toString();
    }

    public static short getFromIndexId(long contraction) {
        return (short)(contraction >> 32 & 0xFFFFL);
    }

    public static short getToIndexId(long contraction) {
        return (short)(contraction & 0xFFFFL);
    }

    public static short getToTensorId(long contraction) {
        return (short)(contraction >> 16 & 0xFFFFL);
    }
}

