/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.MultiTensor;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.SumFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.TensorHashCalculator;
import cc.redberry.core.utils.TensorUtils;
import java.util.Arrays;

public final class Sum
extends MultiTensor {
    final Tensor[] data;
    final int hash;

    Sum(Tensor[] data, Indices indices) {
        super(indices);
        assert (data.length > 1);
        this.data = data;
        Comparable[] wrappers = new TensorWrapper[data.length];
        for (int i = 0; i < data.length; ++i) {
            wrappers[i] = new TensorWrapper(data[i]);
        }
        ArraysUtils.quickSort((Comparable[])wrappers, (Object[])data);
        this.hash = Arrays.hashCode(data);
    }

    Sum(Indices indices, Tensor[] data, int hash) {
        super(indices);
        assert (data.length > 1);
        this.data = data;
        this.hash = hash;
    }

    @Override
    public Tensor[] toArray() {
        return (Tensor[])this.data.clone();
    }

    @Override
    public Tensor get(int i) {
        return this.data[i];
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public Tensor[] getRange(int from, int to) {
        return Arrays.copyOfRange(this.data, from, to);
    }

    @Override
    public Tensor set(int i, Tensor tensor) {
        if (i >= this.data.length || i < 0) {
            throw new IndexOutOfBoundsException();
        }
        Tensor old = this.data[i];
        if (old == tensor) {
            return this;
        }
        if (TensorUtils.equalsExactly(old, tensor)) {
            return this;
        }
        if (TensorUtils.isIndeterminate(tensor)) {
            return tensor;
        }
        if (TensorUtils.isZero(tensor)) {
            return this.remove(i);
        }
        Tensor[] newData = (Tensor[])this.data.clone();
        newData[i] = tensor;
        if (TensorUtils.equals(old, tensor)) {
            return new Sum(newData, this.indices);
        }
        return Tensors.sum(newData);
    }

    @Override
    public Tensor remove(int i) {
        if (i >= this.data.length || i < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.data.length == 2) {
            return this.data[1 - i];
        }
        Tensor[] newData = new Tensor[this.data.length - 1];
        System.arraycopy(this.data, 0, newData, 0, i);
        if (i < this.data.length - 1) {
            System.arraycopy(this.data, i + 1, newData, i, this.data.length - i - 1);
        }
        return new Sum(newData, this.indices);
    }

    @Override
    protected Tensor remove1(int[] positions) {
        Tensor[] newData = new Tensor[this.data.length - positions.length];
        int pointer = 0;
        int counter = -1;
        for (int i = 0; i < this.data.length; ++i) {
            if (pointer < positions.length && i == positions[pointer]) {
                ++pointer;
                continue;
            }
            newData[++counter] = this.data[i];
        }
        if (newData.length == 1) {
            return newData[0];
        }
        return new Sum(newData, this.indices);
    }

    @Override
    protected Complex getNeutral() {
        return Complex.ZERO;
    }

    @Override
    protected Tensor select1(int[] positions) {
        Tensor[] newData = new Tensor[positions.length];
        int i = -1;
        for (int position : positions) {
            newData[++i] = this.data[position];
        }
        return new Sum(newData, this.indices);
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    public TensorBuilder getBuilder() {
        return new SumBuilder(this.data.length);
    }

    @Override
    public TensorFactory getFactory() {
        return SumFactory.FACTORY;
    }

    @Override
    public String toString(OutputFormat mode) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            String str;
            String temp;
            if (((temp = this.get(i).toString(mode, Sum.class)).charAt(0) == '-' || temp.charAt(0) == '+') && sb.length() != 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if ((str = this.get(i).toString(mode, Sum.class)).contains("'") && !mode.printMatrixIndices) {
                return this.toString(mode.printMatrixIndices());
            }
            sb.append(str);
            if (i == this.size() - 1) {
                return sb.toString();
            }
            sb.append('+');
            ++i;
        }
    }

    @Override
    protected String toString(OutputFormat mode, Class<? extends Tensor> clazz) {
        if (clazz == Power.class || clazz == Product.class) {
            return "(" + this.toString(mode) + ")";
        }
        return this.toString(mode);
    }

    private static final class TensorWrapper
    implements Comparable<TensorWrapper> {
        final Tensor tensor;
        final int hashWithIndices;

        public TensorWrapper(Tensor tensor) {
            this.tensor = tensor;
            this.hashWithIndices = TensorHashCalculator.hashWithIndices(tensor);
        }

        @Override
        public int compareTo(TensorWrapper o) {
            int i = this.tensor.compareTo(o.tensor);
            if (i != 0) {
                return i;
            }
            return Integer.compare(this.hashWithIndices, o.hashWithIndices);
        }
    }
}

