/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.PowersContainer;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ScalarsBackedProductBuilder
implements TensorBuilder {
    private final PowersContainer powers;
    private final TIntObjectHashMap<Component> indexToComponent;
    private final Set<Component> components;
    private Complex factor = Complex.ONE;

    public ScalarsBackedProductBuilder() {
        this.powers = new PowersContainer();
        this.indexToComponent = new TIntObjectHashMap();
        this.components = new HashSet<Component>();
    }

    public ScalarsBackedProductBuilder(int powersCapacity, int componentsCapacity, int indicesCapacity) {
        this.powers = new PowersContainer(powersCapacity);
        this.indexToComponent = new TIntObjectHashMap(indicesCapacity);
        this.components = new HashSet<Component>(componentsCapacity);
    }

    private ScalarsBackedProductBuilder(PowersContainer powers, TIntObjectHashMap<Component> indexToComponent, Set<Component> components, Complex factor) {
        this.powers = powers;
        this.indexToComponent = indexToComponent;
        this.components = components;
        this.factor = factor;
    }

    @Override
    public void put(Tensor tensor) {
        if (tensor instanceof Complex) {
            this.factor = this.factor.multiply((Complex)tensor);
            return;
        }
        if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
            return;
        }
        if (tensor instanceof Product) {
            Product p = (Product)tensor;
            this.factor = this.factor.multiply(p.factor);
            if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
                return;
            }
            ProductContent pc = p.getContent();
            for (Tensor t : p.getAllScalarsWithoutFactor()) {
                this.powers.put(t);
            }
            Tensor nonScalar = pc.getNonScalar();
            if (nonScalar == null) {
                return;
            }
            if (nonScalar instanceof Product) {
                for (Tensor t : nonScalar) {
                    this.putNonScalar(t);
                }
            } else {
                this.putNonScalar(nonScalar);
            }
            return;
        }
        if (TensorUtils.isScalar(tensor)) {
            this.powers.put(tensor);
            return;
        }
        this.putNonScalar(tensor);
    }

    private void putNonScalar(Tensor tensor) {
        Component component;
        Object iterator;
        Indices freeIndices = tensor.getIndices().getFree();
        TIntHashSet freeSet = new TIntHashSet(freeIndices.getAllIndices().copy());
        HashSet<Component> toMerge = new HashSet<Component>();
        if (!this.indexToComponent.isEmpty()) {
            iterator = freeSet.iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                assert (!this.indexToComponent.containsKey(index));
                component = (Component)this.indexToComponent.remove(index = IndicesUtils.inverseIndexState(index));
                if (component == null) continue;
                iterator.remove();
                component.freeIndices.remove(index);
                toMerge.add(component);
            }
        }
        if (toMerge.isEmpty()) {
            component = new Component(tensor, freeSet);
            for (int index : freeSet) {
                this.indexToComponent.put(index, (Object)component);
            }
            this.components.add(component);
            return;
        }
        iterator = toMerge.iterator();
        component = (Component)iterator.next();
        component.elements.add(tensor);
        component.freeIndices.addAll((TIntCollection)freeSet);
        for (int index : freeSet) {
            this.indexToComponent.put(index, (Object)component);
        }
        while (iterator.hasNext()) {
            Component temp = (Component)iterator.next();
            for (int index : temp.freeIndices) {
                this.indexToComponent.put(index, (Object)component);
            }
            component.freeIndices.addAll((TIntCollection)temp.freeIndices);
            component.elements.addAll(temp.elements);
            this.components.remove(temp);
        }
        if (component.freeIndices.isEmpty()) {
            this.components.remove(component);
            this.powers.put(new Product(new IndicesBuilder().append(component.elements).getIndices(), Complex.ONE, new Tensor[0], component.elements.toArray(new Tensor[component.elements.size()])));
        }
    }

    @Override
    public Tensor build() {
        if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
            return this.factor;
        }
        if (this.powers.isSign()) {
            this.factor = this.factor.negate();
        }
        ArrayList<Tensor> indexLess = new ArrayList<Tensor>(this.powers.size());
        ArrayList<Tensor> data = new ArrayList<Tensor>();
        for (Tensor power : this.powers) {
            if (power instanceof Complex) {
                this.factor = this.factor.multiply((Complex)power);
                if (!NumberUtils.isZeroOrIndeterminate(this.factor)) continue;
                return this.factor;
            }
            if (TensorUtils.isIndexless(power)) {
                indexLess.add(power);
                continue;
            }
            if (power instanceof Product) {
                for (Tensor t : power) {
                    data.add(t);
                }
                continue;
            }
            data.add(power);
        }
        for (Component component : this.components) {
            data.addAll(component.elements);
        }
        if (indexLess.isEmpty() && data.isEmpty()) {
            return this.factor;
        }
        if (this.factor.isOne()) {
            if (indexLess.size() == 1 && data.isEmpty()) {
                return (Tensor)indexLess.get(0);
            }
            if (indexLess.isEmpty() && data.size() == 1) {
                return (Tensor)data.get(0);
            }
        }
        if (this.factor.isMinusOne()) {
            Sum s = null;
            if (indexLess.size() == 1 && data.isEmpty() && indexLess.get(0) instanceof Sum) {
                s = (Sum)indexLess.get(0);
            }
            if (indexLess.isEmpty() && data.size() == 1 && data.get(0) instanceof Sum) {
                s = (Sum)data.get(0);
            }
            if (s != null) {
                Tensor[] sumData = (Tensor[])s.data.clone();
                for (int i = sumData.length - 1; i >= 0; --i) {
                    sumData[i] = Tensors.negate(sumData[i]);
                }
                return new Sum(s.indices, sumData, s.hashCode());
            }
        }
        return new Product(new IndicesBuilder().append(data).getIndices(), this.factor, indexLess.toArray(new Tensor[indexLess.size()]), data.toArray(new Tensor[data.size()]));
    }

    @Override
    public ScalarsBackedProductBuilder clone() {
        HashSet<Component> newComponents = new HashSet<Component>(this.components.size());
        TIntObjectHashMap nIndexToComponent = new TIntObjectHashMap(this.indexToComponent);
        for (Component curr : this.components) {
            Component component = curr.clone();
            newComponents.add(component);
            TIntIterator iterator = component.freeIndices.iterator();
            while (iterator.hasNext()) {
                nIndexToComponent.put(iterator.next(), (Object)component);
            }
        }
        return new ScalarsBackedProductBuilder(this.powers.clone(), (TIntObjectHashMap<Component>)nIndexToComponent, newComponents, this.factor);
    }

    private static final class Component {
        private final ArrayList<Tensor> elements;
        private final TIntHashSet freeIndices;

        private Component(Tensor tensor, TIntHashSet freeIndices) {
            this.elements = new ArrayList();
            this.elements.add(tensor);
            this.freeIndices = freeIndices;
        }

        private Component(ArrayList<Tensor> elements, TIntHashSet freeIndices) {
            this.elements = elements;
            this.freeIndices = freeIndices;
        }

        public Component clone() {
            return new Component(new ArrayList<Tensor>(this.elements), new TIntHashSet((TIntCollection)this.freeIndices));
        }
    }
}

