/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.tensor.StructureOfContractions;
import cc.redberry.core.tensor.StructureOfContractionsHashed;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.ArrayIterator;
import java.util.Arrays;
import java.util.Iterator;

public final class ProductContent
implements Iterable<Tensor> {
    public static final ProductContent EMPTY_INSTANCE = new ProductContent(StructureOfContractionsHashed.EMPTY_INSTANCE, StructureOfContractions.EMPTY_FULL_CONTRACTIONS_STRUCTURE, new Tensor[0], null, new short[0], new Tensor[0], new int[0]);
    private final StructureOfContractionsHashed structureOfContractionsHashed;
    private final StructureOfContractions structureOfContractions;
    private final Tensor[] scalars;
    private final Tensor nonScalar;
    private final short[] stretchIndices;
    private final Tensor[] data;
    private int[] stretchHashReflection;

    ProductContent(StructureOfContractionsHashed structureOfContractionsHashed, StructureOfContractions structureOfContractions, Tensor[] scalars, Tensor nonScalar, short[] stretchIndices, Tensor[] data) {
        this.structureOfContractionsHashed = structureOfContractionsHashed;
        this.structureOfContractions = structureOfContractions;
        this.scalars = scalars;
        this.nonScalar = nonScalar;
        this.stretchIndices = stretchIndices;
        this.data = data;
    }

    private ProductContent(StructureOfContractionsHashed structureOfContractionsHashed, StructureOfContractions structureOfContractions, Tensor[] scalars, Tensor nonScalar, short[] stretchIndices, Tensor[] data, int[] stretchHashReflection) {
        this.structureOfContractionsHashed = structureOfContractionsHashed;
        this.structureOfContractions = structureOfContractions;
        this.scalars = scalars;
        this.nonScalar = nonScalar;
        this.stretchIndices = stretchIndices;
        this.data = data;
        this.stretchHashReflection = stretchHashReflection;
    }

    public StructureOfContractionsHashed getStructureOfContractionsHashed() {
        return this.structureOfContractionsHashed;
    }

    public StructureOfContractions getStructureOfContractions() {
        return this.structureOfContractions;
    }

    public Tensor getNonScalar() {
        return this.nonScalar;
    }

    public Tensor[] getScalars() {
        return (Tensor[])this.scalars.clone();
    }

    public short[] getStretchIds() {
        return (short[])this.stretchIndices.clone();
    }

    public short getStretchId(int i) {
        return this.stretchIndices[i];
    }

    public Tensor get(int i) {
        return this.data[i];
    }

    public int size() {
        return this.data.length;
    }

    public Tensor[] getRange(int from, int to) {
        return Arrays.copyOfRange(this.data, from, to);
    }

    public Tensor[] getDataCopy() {
        return (Tensor[])this.data.clone();
    }

    @Override
    public Iterator<Tensor> iterator() {
        return new ArrayIterator<Tensor>(this.data);
    }

    public short getStretchIndexByHash(int hashCode) {
        int index;
        if (this.stretchHashReflection == null) {
            this.stretchHashReflection = new int[this.stretchIndices[this.stretchIndices.length - 1] + 1];
            for (int i = 0; i < this.stretchIndices.length; ++i) {
                this.stretchHashReflection[this.stretchIndices[i]] = this.data[i].hashCode();
            }
        }
        if ((index = Arrays.binarySearch(this.stretchHashReflection, hashCode)) < 0) {
            return -1;
        }
        return (short)index;
    }
}

