/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.EmptyIterator;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.function.TObjectFunction;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;

public final class PowersContainer
implements Iterable<Tensor> {
    private boolean sign;
    private final TIntObjectHashMap<ArrayList<PowerNode>> powers;
    private static final TObjectFunction<ArrayList<PowerNode>, ArrayList<PowerNode>> copyPowers = new TObjectFunction<ArrayList<PowerNode>, ArrayList<PowerNode>>(){

        public ArrayList<PowerNode> execute(ArrayList<PowerNode> value) {
            ArrayList<PowerNode> newList = new ArrayList<PowerNode>(value.size());
            for (PowerNode node : value) {
                newList.add(node.clone());
            }
            return newList;
        }
    };

    public PowersContainer() {
        this.powers = new TIntObjectHashMap();
    }

    public PowersContainer(int initialCapacity) {
        this.powers = new TIntObjectHashMap(initialCapacity);
    }

    private PowersContainer(TIntObjectHashMap<ArrayList<PowerNode>> powers, boolean sign) {
        this.powers = powers;
        this.sign = sign;
    }

    public boolean isSign() {
        return this.sign;
    }

    public boolean isEmpty() {
        return this.powers.isEmpty();
    }

    public int size() {
        return this.powers.size();
    }

    public void put(Tensor tensor) {
        Tensor exponent;
        Tensor base;
        if (tensor instanceof Power) {
            base = tensor.get(0);
            exponent = tensor.get(1);
        } else {
            base = tensor;
            exponent = Complex.ONE;
        }
        int hash = base.hashCode();
        ArrayList<PowerNode> nodes = (ArrayList<PowerNode>)this.powers.get(hash);
        if (nodes == null) {
            nodes = new ArrayList<PowerNode>();
            this.powers.put(hash, nodes);
        }
        for (PowerNode node : nodes) {
            Complex exponent1;
            Boolean compare = TensorUtils.compare1(node.base, base);
            if (compare == null) continue;
            if (!compare.booleanValue()) {
                node.putExponent(exponent);
                return;
            }
            if (TensorUtils.isInteger(exponent)) {
                node.putExponent(exponent);
                if (TensorUtils.isIntegerOdd(exponent)) {
                    this.sign = !this.sign;
                }
                return;
            }
            if (node.exponent != null && !((PowerNode)node).exponent.summands.isEmpty() || !(exponent1 = node.exponent == null ? Complex.ONE : ((PowerNode)node).exponent.complex).isInteger()) continue;
            node.base = base;
            node.putExponent(exponent);
            if (NumberUtils.isIntegerOdd(exponent1)) {
                this.sign = !this.sign;
            }
            return;
        }
        nodes.add(new PowerNode(base, exponent));
    }

    public void putNew(Tensor base, Tensor exponent) {
        ArrayList<PowerNode> newNodes = new ArrayList<PowerNode>();
        ArrayList nodes = (ArrayList)this.powers.putIfAbsent(base.hashCode(), newNodes);
        if (nodes != null) {
            nodes.add(new PowerNode(base, exponent));
        } else {
            newNodes.add(new PowerNode(base, exponent));
        }
    }

    @Override
    public Iterator<Tensor> iterator() {
        return new It();
    }

    public PowersContainer clone() {
        TIntObjectHashMap newPowers = new TIntObjectHashMap(this.powers);
        newPowers.transformValues(copyPowers);
        return new PowersContainer((TIntObjectHashMap<ArrayList<PowerNode>>)newPowers, this.sign);
    }

    static final class PowerNode {
        private Tensor base;
        private SumBuilder exponent;

        PowerNode(Tensor base, Tensor exponent) {
            this.base = base;
            if (exponent == Complex.ONE) {
                this.exponent = null;
            } else {
                this.exponent = new SumBuilder();
                this.exponent.put(exponent);
            }
        }

        private PowerNode(SumBuilder exponent, Tensor base) {
            this.exponent = exponent;
            this.base = base;
        }

        void putExponent(Tensor exp) {
            if (this.exponent == null) {
                this.exponent = new SumBuilder();
                this.exponent.put(Complex.ONE);
            }
            this.exponent.put(exp);
        }

        Tensor build() {
            if (this.exponent == null) {
                return this.base;
            }
            return Tensors.pow(this.base, this.exponent.build());
        }

        public PowerNode clone() {
            return new PowerNode(this.exponent == null ? null : (SumBuilder)this.exponent.clone(), this.base);
        }
    }

    private class It
    implements Iterator<Tensor> {
        private final Iterator<ArrayList<PowerNode>> lists;
        private Iterator<PowerNode> nodes;

        private It() {
            this.lists = PowersContainer.this.powers.valueCollection().iterator();
            this.nodes = EmptyIterator.INSTANCE;
        }

        @Override
        public boolean hasNext() {
            if (this.nodes.hasNext()) {
                return true;
            }
            if (!this.lists.hasNext()) {
                return false;
            }
            this.nodes = this.lists.next().iterator();
            return this.hasNext();
        }

        @Override
        public Tensor next() {
            return this.nodes.next().build();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

