/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.MathUtils;

public abstract class MultiTensor
extends Tensor {
    protected final Indices indices;

    MultiTensor(Indices indices) {
        this.indices = indices;
    }

    @Override
    public Indices getIndices() {
        return this.indices;
    }

    public abstract Tensor remove(int var1);

    public Tensor remove(Tensor tensor) {
        int size = this.size();
        for (int l = 0; l < size; ++l) {
            if (this.get(l) != tensor) continue;
            return this.remove(l);
        }
        return tensor;
    }

    public Tensor remove(int[] positions) {
        if (positions.length == 0) {
            return this;
        }
        int size = this.size();
        for (int i : positions) {
            if (i < size && i >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        int[] p = MathUtils.getSortedDistinct((int[])positions.clone());
        if (p.length == size) {
            return this.getNeutral();
        }
        return this.remove1(p);
    }

    protected abstract Tensor remove1(int[] var1);

    public Tensor select(int[] positions) {
        if (positions.length == 0) {
            return this.getNeutral();
        }
        if (positions.length == 1) {
            return this.get(positions[0]);
        }
        int[] p = MathUtils.getSortedDistinct((int[])positions.clone());
        if (p.length == this.size()) {
            return this;
        }
        return this.select1(p);
    }

    protected abstract Complex getNeutral();

    protected abstract Tensor select1(int[] var1);
}

