/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.set.hash.TIntHashSet;

final class FactorNode {
    final Tensor factor;
    private final TensorBuilder builder;
    int[] factorForbiddenIndices;

    FactorNode(Tensor factor, TensorBuilder builder) {
        this.factor = ApplyIndexMapping.optimizeDummies(factor);
        this.builder = builder;
        this.factorForbiddenIndices = TensorUtils.getAllIndicesNamesT(this.factor).toArray();
    }

    private FactorNode(Tensor factor, TensorBuilder builder, int[] factorForbiddenIndices) {
        this.factor = factor;
        this.builder = builder;
        this.factorForbiddenIndices = factorForbiddenIndices;
    }

    void put(Tensor summand, Tensor factor) {
        TIntHashSet allowed = TensorUtils.getAllDummyIndicesT(factor);
        allowed.removeAll(this.factorForbiddenIndices);
        summand = ApplyIndexMapping.renameDummy(summand, this.factorForbiddenIndices, allowed.toArray());
        this.builder.put(summand);
    }

    Tensor build() {
        return this.builder.build();
    }

    public FactorNode clone() {
        return new FactorNode(this.factor, this.builder.clone(), this.factorForbiddenIndices);
    }
}

