/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.solver;

import cc.redberry.core.context.CC;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.solver.ReducedSystem;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Split;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensorgenerator.GeneratedTensor;
import cc.redberry.core.tensorgenerator.TensorGenerator;
import cc.redberry.core.tensorgenerator.TensorGeneratorUtils;
import cc.redberry.core.transformations.CollectNonScalarsTransformation;
import cc.redberry.core.transformations.EliminateMetricsTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.TransformationCollection;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public final class ReduceEngine {
    private static final int ITERATION_LIMIT = 10000;

    private ReduceEngine() {
    }

    public static ReducedSystem reduceToSymbolicSystem(Expression[] equations, SimpleTensor[] vars, Transformation[] rules) {
        return ReduceEngine.reduceToSymbolicSystem(equations, vars, rules, new boolean[vars.length]);
    }

    public static ReducedSystem reduceToSymbolicSystem(Expression[] equations, SimpleTensor[] vars, Transformation[] rules, boolean[] symmetricForm) {
        Tensor[] zeroReduced = new Tensor[equations.length];
        for (int i = equations.length - 1; i >= 0; --i) {
            zeroReduced[i] = Tensors.subtract(equations[i].get(0), equations[i].get(1));
            zeroReduced[i] = ExpandTransformation.expand(zeroReduced[i], EliminateMetricsTransformation.ELIMINATE_METRICS);
            zeroReduced[i] = EliminateMetricsTransformation.eliminate(zeroReduced[i]);
        }
        TIntHashSet varsNames = new TIntHashSet(vars.length);
        for (SimpleTensor var : vars) {
            varsNames.add(var.getName());
        }
        Tensor[] samples = ReduceEngine.getSamples(zeroReduced, varsNames);
        if (samples.length == 0) {
            for (int i = 0; i < vars.length; ++i) {
                if (vars[i].getIndices().size() == 0) continue;
                return null;
            }
        }
        Expression[] generalSolutions = new Expression[vars.length];
        ArrayList<Object> unknownCoefficients = new ArrayList<Object>();
        for (int i = 0; i < generalSolutions.length; ++i) {
            if (vars[i].getIndices().size() == 0) {
                SimpleTensor[] nVar = CC.generateNewSymbol();
                unknownCoefficients.add(nVar);
                generalSolutions[i] = Tensors.expression(vars[i], (Tensor)nVar);
                continue;
            }
            GeneratedTensor generatedTensor = TensorGenerator.generateStructure(vars[i].getIndices(), samples, symmetricForm[i], true, true);
            unknownCoefficients.ensureCapacity(generatedTensor.coefficients.length);
            for (SimpleTensor st : generatedTensor.coefficients) {
                unknownCoefficients.add(st);
            }
            generalSolutions[i] = Tensors.expression(vars[i], generatedTensor.generatedTensor);
        }
        ArrayList<Transformation> allRules = new ArrayList<Transformation>(Arrays.asList(rules));
        allRules.add(0, EliminateMetricsTransformation.ELIMINATE_METRICS);
        TransformationCollection simplification = new TransformationCollection(allRules);
        ArrayList<Expression> reducedSystem = new ArrayList<Expression>();
        for (Tensor equation : zeroReduced) {
            int count = 10000;
            do {
                for (Expression solution : generalSolutions) {
                    equation = solution.transform(equation);
                }
                equation = ExpandTransformation.expand(equation, simplification);
                equation = simplification.transform(equation);
            } while (TensorUtils.containsSimpleTensors(equation = CollectNonScalarsTransformation.collectNonScalars(equation), (TIntSet)varsNames) && count-- > 0);
            if (count <= 0) {
                throw new RuntimeException("Maximum number of iterations exceeded: the system cannot be reduced after 10 000 iterations.");
            }
            if (equation.getIndices().size() == 0) {
                reducedSystem.add(Tensors.expression(equation, Complex.ZERO));
                continue;
            }
            if (equation instanceof Sum) {
                for (Tensor t : equation) {
                    reducedSystem.add(Tensors.expression(Split.splitScalars((Tensor)t).summand, Complex.ZERO));
                }
                continue;
            }
            reducedSystem.add(Tensors.expression(Split.splitScalars((Tensor)equation).summand, Complex.ZERO));
        }
        return new ReducedSystem(reducedSystem.toArray(new Expression[reducedSystem.size()]), unknownCoefficients.toArray(new SimpleTensor[unknownCoefficients.size()]), generalSolutions);
    }

    private static Tensor[] getSamples(Tensor[] zeroReduced, TIntHashSet vars) {
        Collection<SimpleTensor> content = TensorUtils.getAllDiffSimpleTensors(zeroReduced);
        ArrayList<Tensor> samples = new ArrayList<Tensor>(content.size() + 1);
        HashSet<IndexType> usedTypes = new HashSet<IndexType>();
        for (SimpleTensor st : content) {
            if (vars.contains(st.getName()) || st.getIndices().size() == 0) continue;
            if (Tensors.isKroneckerOrMetric(st)) {
                usedTypes.add(IndicesUtils.getTypeEnum(st.getIndices().get(0)));
                continue;
            }
            SimpleIndices si = st.getIndices();
            int[] free = new int[si.size()];
            for (int i = si.size() - 1; i >= 0; --i) {
                usedTypes.add(IndicesUtils.getTypeEnum(si.get(i)));
                free[i] = IndicesUtils.createIndex(i, IndicesUtils.getType(si.get(i)), IndicesUtils.getState(si.get(i)));
            }
            st = Tensors.setIndices(st, IndicesFactory.createSimple(null, si));
            samples.addAll(Arrays.asList(TensorGeneratorUtils.allStatesCombinations(st)));
        }
        for (IndexType type : usedTypes) {
            byte btype = type.getType();
            samples.add(Tensors.createKronecker(IndicesUtils.setType(btype, 0), Integer.MIN_VALUE | IndicesUtils.setType(btype, 1)));
            if (!CC.isMetric(btype)) continue;
            samples.add(Tensors.createMetric(IndicesUtils.setType(btype, 0), IndicesUtils.setType(btype, 1)));
            samples.add(Tensors.createMetric(Integer.MIN_VALUE | IndicesUtils.setType(btype, 0), Integer.MIN_VALUE | IndicesUtils.setType(btype, 1)));
        }
        return samples.toArray(new Tensor[samples.size()]);
    }
}

