/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser.preprocessor;

import cc.redberry.core.indexgenerator.IndexGeneratorImpl;
import cc.redberry.core.indexmapping.IndexMapping;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenSimpleTensor;
import cc.redberry.core.parser.ParseTokenTransformer;
import cc.redberry.core.parser.ParseUtils;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.Indicator;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

@Deprecated
public final class IndicesInsertion
implements ParseTokenTransformer {
    private final int[] upper;
    private final int[] lower;
    private final Indicator<ParseTokenSimpleTensor> indicator;

    public IndicesInsertion(SimpleIndices upper, SimpleIndices lower, Indicator<ParseTokenSimpleTensor> indicator) {
        IndicesInsertion.checkIndices(upper, lower);
        int[] upperArray = new int[upper.size()];
        for (int i = upper.size() - 1; i >= 0; --i) {
            upperArray[i] = IndicesUtils.getNameWithType(upper.get(i));
        }
        this.upper = upperArray;
        this.lower = lower.getAllIndices().copy();
        this.indicator = indicator;
    }

    private static void checkIndices(SimpleIndices upper, SimpleIndices lower) {
        if (upper.size() != lower.size()) {
            throw new IllegalArgumentException("Upper indices size not equal to lower indices size.");
        }
        int size = upper.size();
        for (int i = 0; i < size; ++i) {
            if (!IndicesUtils.getState(upper.get(i)) || IndicesUtils.getState(lower.get(i))) {
                throw new IllegalArgumentException();
            }
            if (IndicesUtils.getType(upper.get(i)) != IndicesUtils.getType(lower.get(i))) {
                throw new IllegalArgumentException();
            }
            if (i == 0 || IndicesUtils.getType(upper.get(i - 1)) == IndicesUtils.getType(upper.get(i))) continue;
            throw new IllegalArgumentException("Many types.");
        }
    }

    @Override
    public ParseToken transform(ParseToken node) {
        int i;
        int[] freeIndices = node.getIndices().getFree().getAllIndices().copy();
        for (i = 0; i < freeIndices.length; ++i) {
            freeIndices[i] = IndicesUtils.getNameWithType(freeIndices[i]);
        }
        Arrays.sort(freeIndices);
        for (i = this.upper.length - 1; i >= 0; --i) {
            if (Arrays.binarySearch(freeIndices, this.upper[i]) < 0) continue;
            throw new IllegalArgumentException("Inconsistent indices.");
        }
        for (i = this.lower.length - 1; i >= 0; --i) {
            if (Arrays.binarySearch(freeIndices, this.lower[i]) < 0) continue;
            throw new IllegalArgumentException("Inconsistent indices.");
        }
        Set<Integer> dummyIndices = ParseUtils.getAllIndices(node);
        Arrays.sort(this.upper);
        Arrays.sort(this.lower);
        int[] upperLower = MathUtils.intSetUnion(this.upper, this.lower);
        int[] forbidden = new int[dummyIndices.size() + upperLower.length];
        i = -1;
        for (Integer f : dummyIndices) {
            forbidden[++i] = f;
        }
        System.arraycopy(upperLower, 0, forbidden, dummyIndices.size(), upperLower.length);
        IndexGeneratorImpl generator = new IndexGeneratorImpl(forbidden);
        IntArrayList from = new IntArrayList();
        IntArrayList to = new IntArrayList();
        for (i = upperLower.length - 1; i >= 0; --i) {
            int fromIndex = upperLower[i];
            if (!dummyIndices.contains(fromIndex)) continue;
            from.add(fromIndex);
            to.add(generator.generate(IndicesUtils.getType(fromIndex)));
        }
        int[] _from = from.toArray();
        int[] _to = to.toArray();
        ArraysUtils.quickSort(_from, _to);
        IITransformer transformer = IndicesInsertion.createTransformer(node, this.indicator);
        if (transformer != null) {
            transformer.apply(new IndexMapper(_from, _to), new IGWrapper(generator), this.upper, this.lower);
        }
        return node;
    }

    private static IITransformer createTransformer(ParseToken node, Indicator<ParseTokenSimpleTensor> indicator) {
        switch (node.tokenType) {
            case TensorField: 
            case SimpleTensor: {
                if (indicator.is((ParseTokenSimpleTensor)node)) {
                    return new SimpleTransformer((ParseTokenSimpleTensor)node);
                }
                return null;
            }
            case Product: 
            case Expression: 
            case Sum: {
                ArrayList<IITransformer> transformers = new ArrayList<IITransformer>();
                for (ParseToken _node : node.content) {
                    IITransformer t = IndicesInsertion.createTransformer(_node, indicator);
                    if (t == null) continue;
                    transformers.add(t);
                }
                if (transformers.isEmpty()) {
                    return null;
                }
                if (transformers.size() == 1) {
                    return (IITransformer)transformers.get(0);
                }
                if (node.tokenType == TokenType.Product) {
                    return new ProductTransformer(transformers.toArray(new IITransformer[transformers.size()]));
                }
                return new SumTransformer(transformers.toArray(new IITransformer[transformers.size()]));
            }
        }
        return null;
    }

    private static class IGWrapper {
        private IndexGeneratorImpl generator;
        private int generated;

        public IGWrapper(IndexGeneratorImpl generator) {
            this.generator = generator;
        }

        public IGWrapper(IndexGeneratorImpl generator, int generated) {
            this.generator = generator;
            this.generated = generated;
        }

        public int next(byte type) {
            ++this.generated;
            return this.generator.generate(type);
        }

        public void merge(IGWrapper wrapper) {
            if (wrapper.generated > this.generated) {
                this.generated = wrapper.generated;
                this.generator = wrapper.generator;
            }
        }

        public IGWrapper clone() {
            return new IGWrapper(this.generator.clone(), this.generated);
        }
    }

    private static class ProductTransformer
    extends MIITransformer {
        public ProductTransformer(IITransformer[] transformers) {
            super(transformers);
        }

        @Override
        public void apply(IndexMapper indexMapper, IGWrapper generator, int[] upper, int[] lower) {
            int i;
            int[] tempUpper = (int[])upper.clone();
            int[] tempLower = new int[upper.length];
            for (i = 0; i < this.transformers.length - 1; ++i) {
                for (int j = 0; j < upper.length; ++j) {
                    tempLower[j] = generator.next(IndicesUtils.getType(lower[j]));
                }
                this.transformers[i].apply(indexMapper, generator, tempUpper, tempLower);
                System.arraycopy(tempLower, 0, tempUpper, 0, tempUpper.length);
            }
            this.transformers[i].apply(indexMapper, generator, tempUpper, lower);
        }
    }

    private static class SumTransformer
    extends MIITransformer {
        public SumTransformer(IITransformer[] transformers) {
            super(transformers);
        }

        @Override
        public void apply(IndexMapper indexMapper, IGWrapper generator, int[] upper, int[] lower) {
            IGWrapper generatorTemp = null;
            for (int i = 0; i < this.transformers.length - 1; ++i) {
                IGWrapper generatorClone = generator.clone();
                this.transformers[i].apply(indexMapper, generatorClone, upper, lower);
                if (generatorTemp == null) {
                    generatorTemp = generatorClone;
                    continue;
                }
                generatorTemp.merge(generatorClone);
            }
            this.transformers[this.transformers.length - 1].apply(indexMapper, generator, upper, lower);
            if (generatorTemp != null) {
                generator.merge(generatorTemp);
            }
        }
    }

    private static abstract class MIITransformer
    implements IITransformer {
        protected final IITransformer[] transformers;

        public MIITransformer(IITransformer[] transformers) {
            this.transformers = transformers;
        }
    }

    private static class SimpleTransformer
    implements IITransformer {
        private final ParseTokenSimpleTensor node;

        public SimpleTransformer(ParseTokenSimpleTensor node) {
            this.node = node;
        }

        @Override
        public void apply(IndexMapper indexMapper, IGWrapper generator, int[] upper, int[] lower) {
            int i;
            SimpleIndices oldIndices = this.node.indices;
            int[] _newIndices = new int[oldIndices.size() + 2 * upper.length];
            for (i = 0; i < oldIndices.size(); ++i) {
                _newIndices[i] = indexMapper.map(oldIndices.get(i));
            }
            System.arraycopy(upper, 0, _newIndices, oldIndices.size(), upper.length);
            System.arraycopy(lower, 0, _newIndices, oldIndices.size() + upper.length, lower.length);
            for (i = 0; i < upper.length; ++i) {
                int n = i + oldIndices.size();
                _newIndices[n] = _newIndices[n] | Integer.MIN_VALUE;
            }
            this.node.indices = IndicesFactory.createSimple(null, _newIndices);
        }
    }

    private static interface IITransformer {
        public void apply(IndexMapper var1, IGWrapper var2, int[] var3, int[] var4);
    }

    private static class IndexMapper
    implements IndexMapping {
        private final int[] from;
        private final int[] to;

        public IndexMapper(int[] from, int[] to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public int map(int index) {
            int position = Arrays.binarySearch(this.from, IndicesUtils.getNameWithType(index));
            if (position < 0) {
                return index;
            }
            return IndicesUtils.getRawStateInt(index) ^ this.to[position];
        }
    }
}

