/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.TokenParser;
import cc.redberry.core.parser.TokenType;

public class ParserPower
implements TokenParser {
    public static final ParserPower INSTANCE = new ParserPower();
    private static final String power = "Power";
    private static final int minLength = "Power".length() + 2;

    private ParserPower() {
    }

    @Override
    public int priority() {
        return 9986;
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        if (expression.length() <= minLength) {
            return null;
        }
        if (!"Power[".equals(expression.substring(0, power.length() + 1)) || expression.charAt(expression.length() - 1) != ']') {
            return null;
        }
        int level = 0;
        int comma = -1;
        for (int i = power.length(); i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '[') {
                ++level;
            }
            if (level < 1) {
                return null;
            }
            if (c == ']') {
                --level;
            }
            if (c != ',' || level != 1) continue;
            if (comma != -1) {
                throw new ParserException("Power takes only two arguments.");
            }
            comma = i;
        }
        ParseToken arg = parser.parse(expression.substring(power.length() + 1, comma));
        ParseToken power = parser.parse(expression.substring(comma + 1, expression.length() - 1));
        return new ParseToken(TokenType.Power, arg, power);
    }
}

