/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenSimpleTensor;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;

public class ParseTokenTensorField
extends ParseTokenSimpleTensor {
    public SimpleIndices[] argumentsIndices;

    public ParseTokenTensorField(SimpleIndices indices, String name, ParseToken[] content, SimpleIndices[] argumentsIndices) {
        super(indices, name, TokenType.TensorField, content);
        this.argumentsIndices = argumentsIndices;
    }

    @Override
    public NameAndStructureOfIndices getIndicesTypeStructureAndName() {
        StructureOfIndices[] typeStructures = new StructureOfIndices[1 + this.argumentsIndices.length];
        typeStructures[0] = StructureOfIndices.create(this.indices);
        for (int i = 0; i < this.argumentsIndices.length; ++i) {
            if (this.argumentsIndices[i] == null) {
                this.argumentsIndices[i] = IndicesFactory.createSimple(null, this.content[i].getIndices().getFree());
            }
            typeStructures[i + 1] = StructureOfIndices.create(this.argumentsIndices[i]);
        }
        return new NameAndStructureOfIndices(this.name, typeStructures);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append('[');
        for (ParseToken node : this.content) {
            sb.append(node.toString()).append(", ");
        }
        sb.deleteCharAt(sb.length() - 1).deleteCharAt(sb.length() - 1).append(']');
        return sb.toString();
    }

    @Override
    public Tensor toTensor() {
        int i;
        Tensor[] arguments = this.contentToTensors();
        for (i = 0; i < arguments.length; ++i) {
            if (this.argumentsIndices[i] != null) continue;
            this.argumentsIndices[i] = IndicesFactory.createSimple(null, arguments[i].getIndices().getFree());
        }
        i = this.name.indexOf(126);
        if (i >= 0) {
            String[] ordersStr;
            String ordersDescriptor = this.name.substring(i + 1);
            String fieldName = this.name.substring(0, i);
            if ((ordersDescriptor = ordersDescriptor.replace(" ", "")).length() == 0) {
                throw new ParserException("Error in derivative orders in \"" + this.name + "\"");
            }
            if (ordersDescriptor.charAt(0) == '(') {
                if (ordersDescriptor.charAt(ordersDescriptor.length() - 1) != ')') {
                    throw new ParserException("Unbalanced brackets in derivative orders in \"" + this.name + "\"");
                }
                ordersDescriptor = ordersDescriptor.substring(1, ordersDescriptor.length() - 1);
            }
            if ((ordersStr = ordersDescriptor.split(",")).length != arguments.length) {
                throw new ParserException("Number of arguments does not match number of derivative orders in \"" + this.name + "\"");
            }
            int[] orders = new int[ordersStr.length];
            for (i = orders.length - 1; i >= 0; --i) {
                try {
                    orders[i] = Integer.parseInt(ordersStr[i], 10);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Illegal order of derivative: \"" + ordersStr[i] + "\" in \"" + this.name + "\"");
                }
            }
            return Tensors.fieldDerivative(fieldName, this.indices, this.argumentsIndices, this.contentToTensors(), orders);
        }
        return Tensors.field(this.name, this.indices, this.argumentsIndices, this.contentToTensors());
    }
}

