/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import java.util.Objects;

public final class ParseTokenScalarFunction
extends ParseToken {
    public String function;

    public ParseTokenScalarFunction(String function, ParseToken[] content) {
        super(TokenType.ScalarFunction, content);
        if (content.length != 1) {
            throw new IllegalArgumentException();
        }
        this.function = function;
    }

    @Override
    public Indices getIndices() {
        return IndicesFactory.EMPTY_INDICES;
    }

    @Override
    public String toString() {
        return this.function + "[" + this.content[0] + "]";
    }

    @Override
    public Tensor toTensor() {
        if (this.content.length != 1) {
            throw new IllegalArgumentException("Wrong scalar function node.");
        }
        Tensor arg = this.content[0].toTensor();
        switch (this.function.toLowerCase()) {
            case "sin": {
                return Tensors.sin(arg);
            }
            case "cos": {
                return Tensors.cos(arg);
            }
            case "tan": {
                return Tensors.tan(arg);
            }
            case "cot": {
                return Tensors.cot(arg);
            }
            case "arcsin": {
                return Tensors.arcsin(arg);
            }
            case "arccos": {
                return Tensors.arccos(arg);
            }
            case "arctan": {
                return Tensors.arctan(arg);
            }
            case "arccot": {
                return Tensors.arccot(arg);
            }
            case "log": {
                return Tensors.log(arg);
            }
            case "exp": {
                return Tensors.exp(arg);
            }
        }
        throw new IllegalStateException("Unknown scalar function \"" + this.function + "\".");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ParseTokenScalarFunction other = (ParseTokenScalarFunction)obj;
        return Objects.equals(this.function, other.function);
    }
}

