/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.context.Context;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;

public class ParseTokenExpression
extends ParseToken {
    public final boolean preprocess;

    public ParseTokenExpression(boolean preprocess, ParseToken lhs, ParseToken rhs) {
        super(TokenType.Expression, lhs, rhs);
        this.preprocess = preprocess;
    }

    @Override
    public Indices getIndices() {
        return this.content[0].getIndices().getFree();
    }

    @Override
    public Tensor toTensor() {
        Tensor expression = Tensors.expression(this.content[0].toTensor(), this.content[1].toTensor());
        if (this.preprocess) {
            for (Transformation tr : Context.get().getParseManager().defaultTensorPreprocessors) {
                expression = tr.transform(expression);
            }
            Context.get().getParseManager().defaultTensorPreprocessors.add((Transformation)((Object)expression));
        }
        return expression;
    }
}

