/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number.parser;

import cc.redberry.core.number.Number;
import cc.redberry.core.number.parser.BracketsError;
import cc.redberry.core.number.parser.NumberParser;
import cc.redberry.core.number.parser.TokenParser;

public abstract class OperatorToken<T extends Number<T>>
implements TokenParser<T> {
    private final char operationSymbol;
    private final char operationInverseSymbol;

    public OperatorToken(char operationSymbol, char operationInverseSymbol) {
        this.operationSymbol = operationSymbol;
        this.operationInverseSymbol = operationInverseSymbol;
    }

    private boolean canParse(String expression) {
        if (expression.contains("**")) {
            return false;
        }
        char[] expressionChars = expression.toCharArray();
        int level = 0;
        for (char c : expressionChars) {
            if (c == '(' || c == '[') {
                ++level;
            }
            if (c == ')' || c == ']') {
                --level;
            }
            if (level < 0) {
                throw new BracketsError(expression);
            }
            if (c == this.operationSymbol && level == 0) {
                return true;
            }
            if (c != this.operationInverseSymbol || level != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public T parse(String expression, NumberParser<T> parser) {
        if (!this.canParse(expression)) {
            return null;
        }
        char[] expressionChars = expression.toCharArray();
        StringBuffer buffer = new StringBuffer();
        T temp = this.neutral();
        int level = 0;
        boolean mode = false;
        for (char c : expressionChars) {
            if (c == '(') {
                ++level;
            }
            if (c == ')') {
                --level;
            }
            if (level < 0) {
                throw new BracketsError();
            }
            if (c == this.operationSymbol && level == 0) {
                if (buffer.length() != 0) {
                    temp = this.operation(temp, parser.parse(buffer.toString()), mode);
                }
                buffer = new StringBuffer();
                mode = false;
                continue;
            }
            if (c == this.operationInverseSymbol && level == 0) {
                if (buffer.length() != 0) {
                    temp = this.operation(temp, parser.parse(buffer.toString()), mode);
                }
                buffer = new StringBuffer();
                mode = true;
                continue;
            }
            buffer.append(c);
        }
        if (temp == null) {
            temp = this.neutral();
        }
        temp = this.operation(temp, parser.parse(buffer.toString()), mode);
        return temp;
    }

    protected abstract T neutral();

    protected abstract T operation(T var1, T var2, boolean var3);
}

