/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number;

import cc.redberry.core.number.Complex;
import org.apache.commons.math3.util.FastMath;

public final class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex sin(Complex complex) {
        if (complex.isReal()) {
            return new Complex(FastMath.sin((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).sin());
    }

    public static Complex cos(Complex complex) {
        if (complex.isReal()) {
            return new Complex(FastMath.cos((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).cos());
    }

    public static Complex tan(Complex complex) {
        if (complex.isReal()) {
            return new Complex(FastMath.tan((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).tan());
    }

    public static Complex cot(Complex complex) {
        if (complex.isReal()) {
            return new Complex(1.0 / FastMath.tan((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).tan().reciprocal());
    }

    public static Complex arcsin(Complex complex) {
        double x;
        if (complex.isReal() && (x = complex.getReal().doubleValue()) <= 1.0 && x >= -1.0) {
            return new Complex(FastMath.asin((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).asin());
    }

    public static Complex arccos(Complex complex) {
        double x;
        if (complex.isReal() && (x = complex.getReal().doubleValue()) <= 1.0 && x >= -1.0) {
            return new Complex(FastMath.acos((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).acos());
    }

    public static Complex arctan(Complex complex) {
        if (complex.isReal()) {
            return new Complex(FastMath.atan((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).atan());
    }

    public static Complex arccot(Complex complex) {
        if (complex.isReal()) {
            return new Complex(FastMath.atan((double)(1.0 / complex.getReal().doubleValue())));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).reciprocal().atan());
    }

    public static Complex log(Complex complex) {
        double x;
        if (complex.isReal() && (x = complex.getReal().doubleValue()) >= 0.0) {
            return new Complex(FastMath.log((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).log());
    }

    public static Complex exp(Complex complex) {
        if (complex.isReal()) {
            return new Complex(FastMath.exp((double)complex.getReal().doubleValue()));
        }
        return new Complex(new org.apache.commons.math3.complex.Complex(complex.getReal().doubleValue(), complex.getImaginary().doubleValue()).exp());
    }
}

