/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.number.ComplexField;
import cc.redberry.core.number.Number;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.number.Numeric;
import cc.redberry.core.number.Rational;
import cc.redberry.core.number.Real;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.util.FastMath;

public final class Complex
extends Tensor
implements Number<Complex>,
Serializable {
    public static final Complex ComplexNaN = new Complex(Numeric.NaN, Numeric.NaN);
    public static final Complex REAL_POSITIVE_INFINITY = new Complex(Numeric.POSITIVE_INFINITY, Numeric.ZERO);
    public static final Complex REAL_NEGATIVE_INFINITY = new Complex(Numeric.NEGATIVE_INFINITY, Numeric.ZERO);
    public static final Complex IMAGINARY_POSITIVE_INFINITY = new Complex(Numeric.ZERO, Numeric.POSITIVE_INFINITY);
    public static final Complex IMAGINARY_NEGATIVE_INFINITY = new Complex(Numeric.ZERO, Numeric.NEGATIVE_INFINITY);
    public static final Complex COMPLEX_NEGATIVE_INFINITY = new Complex(Numeric.NEGATIVE_INFINITY, Numeric.NEGATIVE_INFINITY);
    public static final Complex COMPLEX_POSITIVE_INFINITY;
    public static final Complex COMPLEX_INFINITY;
    public static final Complex ZERO;
    public static final Complex ONE;
    public static final Complex ONE_HALF;
    public static final Complex TWO;
    public static final Complex FOUR;
    public static final Complex MINUS_ONE;
    public static final Complex MINUS_ONE_HALF;
    public static final Complex MINUS_TWO;
    public static final Complex IMAGINARY_UNIT;
    public static final Complex NEGATIVE_IMAGINARY_UNIT;
    private final Real real;
    private final Real imaginary;

    public Complex(Real real, Real imaginary) {
        if (real instanceof Numeric || imaginary instanceof Numeric) {
            this.real = (Real)real.getNumericValue();
            this.imaginary = (Real)imaginary.getNumericValue();
        } else {
            this.real = real;
            this.imaginary = imaginary;
        }
    }

    public Complex(Real real) {
        if (real instanceof Numeric) {
            this.real = (Real)real.getNumericValue();
            this.imaginary = Numeric.ZERO;
        } else {
            this.real = real;
            this.imaginary = Rational.ZERO;
        }
    }

    public Complex(org.apache.commons.math3.complex.Complex complex) {
        this(complex.getReal(), complex.getImaginary());
    }

    public Complex(int real, int imaginary) {
        this(new Rational(real), new Rational(imaginary));
    }

    public Complex(int real) {
        this(new Rational(real), Rational.ZERO);
    }

    public Complex(double real, double imaginary) {
        this(new Numeric(real), new Numeric(imaginary));
    }

    public Complex(int real, double imaginary) {
        this(new Numeric(real), new Numeric(imaginary));
    }

    public Complex(double real, int imaginary) {
        this(new Numeric(real), new Numeric(imaginary));
    }

    public Complex(double real) {
        this(new Numeric(real), Numeric.ZERO);
    }

    public Complex(long real) {
        this(new Rational(real), Rational.ZERO);
    }

    public Complex(long real, long imaginary) {
        this(new Rational(real), new Rational(imaginary));
    }

    public Complex(BigInteger real, BigInteger imaginary) {
        this(new Rational(real), new Rational(imaginary));
    }

    public Complex(BigInteger real) {
        this(new Rational(real), Rational.ZERO);
    }

    @Override
    public Tensor get(int i) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Indices getIndices() {
        return IndicesFactory.EMPTY_INDICES;
    }

    @Override
    protected int hash() {
        return 47 * (329 + this.real.hashCode()) + this.imaginary.hashCode();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public String toString(OutputFormat mode) {
        if (this.real.isZero()) {
            if (this.imaginary.isZero()) {
                return "0";
            }
            if (this.imaginary.isOne()) {
                return "I";
            }
            if (this.imaginary.isMinusOne()) {
                return "-I";
            }
            return this.imaginary.toString() + "*I";
        }
        int is = this.imaginary.signum();
        if (is == 0) {
            return this.real.toString();
        }
        Real abs = (Real)this.imaginary.abs();
        if (is < 0) {
            if (abs.isOne()) {
                return this.real.toString() + "-I";
            }
            return this.real.toString() + "-I*" + this.imaginary.abs();
        }
        if (abs.isOne()) {
            return this.real.toString() + "+I";
        }
        return this.real.toString() + "+I*" + this.imaginary.abs();
    }

    @Override
    protected String toString(OutputFormat mode, Class<? extends Tensor> clazz) {
        if (!(clazz != Product.class && clazz != Power.class || this.imaginary.isZero() && this.real.signum() >= 0 && this.real.isInteger())) {
            return "(" + this.toString(mode) + ")";
        }
        return this.toString(mode);
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ComplexBuilder(this);
    }

    @Override
    public TensorFactory getFactory() {
        return null;
    }

    public Real getImaginary() {
        return this.imaginary;
    }

    public Real getReal() {
        return this.real;
    }

    public Complex getImaginaryPart() {
        return new Complex((Real)this.imaginary.getField().getZero(), this.imaginary);
    }

    public Complex getRealPart() {
        return new Complex(this.real);
    }

    public boolean isReal() {
        return this.imaginary.isZero();
    }

    public boolean isImaginary() {
        return this.real.isZero();
    }

    public Complex getImaginaryAsComplex() {
        if (this.imaginary.isOne()) {
            return ONE;
        }
        if (this.imaginary.isZero()) {
            return ZERO;
        }
        return new Complex(Rational.ZERO, this.imaginary);
    }

    public Complex getRealAsComplex() {
        if (this.real.isOne()) {
            return ONE;
        }
        if (this.real.isZero()) {
            return ZERO;
        }
        return new Complex(this.real);
    }

    @Override
    public boolean isNaN() {
        return this.real.isNaN() || this.imaginary.isNaN();
    }

    @Override
    public boolean isNumeric() {
        return this.real.isNumeric();
    }

    @Override
    public boolean isInfinite() {
        return this.real.isInfinite() || this.imaginary.isInfinite();
    }

    @Override
    public boolean isZero() {
        return this.real.isZero() && this.imaginary.isZero();
    }

    @Override
    public boolean isOne() {
        return this.real.isOne() && this.imaginary.isZero();
    }

    @Override
    public boolean isMinusOne() {
        return this.real.isMinusOne() && this.imaginary.isZero();
    }

    public boolean isOneOrMinusOne() {
        return this.imaginary.isZero() && (this.real.isOne() || this.real.isMinusOne());
    }

    @Override
    public double doubleValue() {
        return this.real.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.real.floatValue();
    }

    @Override
    public int intValue() {
        return this.real.intValue();
    }

    @Override
    public BigInteger bigIntValue() {
        return this.real.bigIntValue();
    }

    @Override
    public long longValue() {
        return this.real.longValue();
    }

    public Complex conjugate() {
        return new Complex(this.real, (Real)this.imaginary.negate());
    }

    public Complex add(Complex a) {
        NumberUtils.checkNotNull(a);
        return a.isZero() ? (a.isNumeric() ? this.getNumericValue() : this) : new Complex((Real)this.real.add(a.real), (Real)this.imaginary.add(a.imaginary));
    }

    public Complex divide(Complex divisor) {
        NumberUtils.checkNotNull(divisor);
        if (divisor.isOne()) {
            return divisor.isNumeric() ? this.getNumericValue() : this;
        }
        if (divisor.isNaN() || this.isNaN()) {
            return ComplexNaN;
        }
        Real c = divisor.real;
        Real d = divisor.imaginary;
        if (((Real)c.abs()).compareTo(d.abs()) < 0) {
            Real q = (Real)c.divide(d);
            Real denominator = (Real)((Real)c.multiply(q)).add(d);
            return new Complex((Real)((Real)((Real)this.real.multiply(q)).add(this.imaginary)).divide(denominator), (Real)((Real)((Real)this.imaginary.multiply(q)).subtract(this.real)).divide(denominator));
        }
        Real q = (Real)d.divide(c);
        Real denominator = (Real)((Real)d.multiply(q)).add(c);
        return new Complex((Real)((Real)((Real)this.imaginary.multiply(q)).add(this.real)).divide(denominator), (Real)((Real)this.imaginary.subtract(this.real.multiply(q))).divide(denominator));
    }

    public Field<Complex> getField() {
        return ComplexField.getInstance();
    }

    public Complex multiply(int n) {
        return n == 1 ? this : new Complex((Real)this.real.multiply(n), (Real)this.imaginary.multiply(n));
    }

    public Complex multiply(Complex factor) {
        NumberUtils.checkNotNull(factor);
        if (factor.isNaN()) {
            return ComplexNaN;
        }
        return new Complex((Real)((Real)this.real.multiply(factor.real)).subtract(this.imaginary.multiply(factor.imaginary)), (Real)((Real)this.real.multiply(factor.imaginary)).add(this.imaginary.multiply(factor.real)));
    }

    public Complex negate() {
        return new Complex((Real)this.real.negate(), (Real)this.imaginary.negate());
    }

    public Complex reciprocal() {
        if (this.isNaN()) {
            return ComplexNaN;
        }
        if (((Real)this.real.abs()).compareTo(this.imaginary.abs()) < 0) {
            Real q = (Real)this.real.divide(this.imaginary);
            Real scale = (Real)((Real)((Real)this.real.multiply(q)).add(this.imaginary)).reciprocal();
            return new Complex((Real)scale.multiply(q), (Real)scale.negate());
        }
        Real q = (Real)this.imaginary.divide(this.real);
        Real scale = (Real)((Real)((Real)this.imaginary.multiply(q)).add(this.real)).reciprocal();
        return new Complex(scale, (Real)((Real)scale.multiply(q)).negate());
    }

    public Complex subtract(Complex a) {
        NumberUtils.checkNotNull(a);
        return a.isZero() ? (a.isNumeric() ? this.getNumericValue() : this) : new Complex((Real)this.real.subtract(a.real), (Real)this.imaginary.subtract(a.imaginary));
    }

    @Override
    public Complex getNumericValue() {
        return this.isNumeric() ? this : new Complex((Real)this.real.getNumericValue(), (Real)this.imaginary.getNumericValue());
    }

    @Override
    public Complex abs() {
        if (this.isZero() || this.isOne() || this.isInfinite() || this.isNaN()) {
            return this;
        }
        Real abs2 = (Real)((Real)this.real.multiply(this.real)).add(this.imaginary.multiply(this.imaginary));
        if (this.isNumeric()) {
            return new Complex((Real)abs2.pow(0.5));
        }
        Rational abs2r = (Rational)abs2;
        BigInteger num = abs2r.getNumerator();
        BigInteger den = abs2r.getDenominator();
        BigInteger nR = NumberUtils.sqrt(num);
        if (!NumberUtils.isSqrt(num, nR)) {
            throw new IllegalStateException();
        }
        BigInteger dR = NumberUtils.sqrt(den);
        if (!NumberUtils.isSqrt(den, dR)) {
            throw new IllegalStateException();
        }
        return new Complex(new Rational(nR, dR));
    }

    public double absNumeric() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        double real = this.real.doubleValue();
        double imaginary = this.imaginary.doubleValue();
        return Complex.absNumeric(real, imaginary);
    }

    public static double absNumeric(double real, double imaginary) {
        if (FastMath.abs((double)real) < FastMath.abs((double)imaginary)) {
            if (imaginary == 0.0) {
                return FastMath.abs((double)real);
            }
            double q = real / imaginary;
            return FastMath.abs((double)imaginary) * FastMath.sqrt((double)(1.0 + q * q));
        }
        if (real == 0.0) {
            return FastMath.abs((double)imaginary);
        }
        double q = imaginary / real;
        return FastMath.abs((double)real) * FastMath.sqrt((double)(1.0 + q * q));
    }

    @Override
    public Complex add(BigFraction fraction) {
        return fraction.compareTo(BigFraction.ZERO) == 0 ? this : new Complex((Real)this.real.add(fraction), this.imaginary);
    }

    @Override
    public Complex add(double d) {
        return d == 0.0 ? this.getNumericValue() : new Complex((Real)this.real.add(d), this.imaginary);
    }

    @Override
    public Complex add(long d) {
        return d == 0L ? this : new Complex((Real)this.real.add(d), this.imaginary);
    }

    @Override
    public Complex add(int d) {
        return d == 0 ? this : new Complex((Real)this.real.add(d), this.imaginary);
    }

    @Override
    public Complex add(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return bg.equals(BigInteger.ZERO) ? this : new Complex((Real)this.real.add(bg), this.imaginary);
    }

    @Override
    public Complex subtract(BigFraction fraction) {
        return fraction.compareTo(BigFraction.ZERO) == 0 ? this : new Complex((Real)this.real.subtract(fraction), this.imaginary);
    }

    @Override
    public Complex subtract(double d) {
        return d == 0.0 ? this.getNumericValue() : new Complex((Real)this.real.subtract(d), this.imaginary);
    }

    @Override
    public Complex subtract(long l) {
        return l == 0L ? this : new Complex((Real)this.real.subtract(l), this.imaginary);
    }

    @Override
    public Complex subtract(int i) {
        return i == 0 ? this : new Complex((Real)this.real.subtract(i), this.imaginary);
    }

    @Override
    public Complex subtract(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return bg.equals(BigInteger.ZERO) ? this : new Complex((Real)this.real.subtract(bg), this.imaginary);
    }

    @Override
    public Complex multiply(BigFraction fraction) {
        return fraction.compareTo(BigFraction.ONE) == 0 ? this : new Complex((Real)this.real.multiply(fraction), (Real)this.imaginary.multiply(fraction));
    }

    @Override
    public Complex multiply(double d) {
        return d == 1.0 ? this.getNumericValue() : (Double.isNaN(d) ? ComplexNaN : new Complex((Real)this.real.multiply(d), (Real)this.imaginary.multiply(d)));
    }

    @Override
    public Complex multiply(BigInteger bg) {
        return bg.compareTo(BigInteger.ONE) == 0 ? this : new Complex((Real)this.real.multiply(bg), (Real)this.imaginary.multiply(bg));
    }

    @Override
    public Complex multiply(long d) {
        return d == 1L ? this : new Complex((Real)this.real.multiply(d), (Real)this.imaginary.multiply(d));
    }

    @Override
    public Complex divide(BigFraction fraction) {
        return fraction.compareTo(BigFraction.ONE) == 0 ? this : new Complex((Real)this.real.divide(fraction), (Real)this.imaginary.divide(fraction));
    }

    @Override
    public Complex divide(long l) {
        return l == 1L ? this : new Complex((Real)this.real.divide(l), (Real)this.imaginary.divide(l));
    }

    @Override
    public Complex divide(int i) {
        return i == 1 ? this : new Complex((Real)this.real.divide(i), (Real)this.imaginary.divide(i));
    }

    @Override
    public Complex divide(BigInteger bg) {
        return bg.compareTo(BigInteger.ONE) == 0 ? this : new Complex((Real)this.real.divide(bg), (Real)this.imaginary.divide(bg));
    }

    @Override
    public Complex divide(double d) {
        return d == 1.0 ? this : new Complex((Real)this.real.divide(d), (Real)this.imaginary.divide(d));
    }

    public Complex add(Real d) {
        NumberUtils.checkNotNull(d);
        return d.isZero() ? (d.isNumeric() ? this.getNumericValue() : this) : new Complex((Real)this.real.add(d), (Real)this.imaginary.add(d));
    }

    public Complex subtract(Real d) {
        NumberUtils.checkNotNull(d);
        return d.isZero() ? (d.isNumeric() ? this.getNumericValue() : this) : new Complex((Real)this.real.subtract(d), (Real)this.imaginary.add(d));
    }

    public Complex multiply(Real d) {
        NumberUtils.checkNotNull(d);
        return d.isOne() ? (d.isNumeric() ? this.getNumericValue() : this) : new Complex((Real)this.real.multiply(d), (Real)this.imaginary.multiply(d));
    }

    public Complex divide(Real d) {
        NumberUtils.checkNotNull(d);
        return d.isOne() ? (d.isNumeric() ? this.getNumericValue() : this) : new Complex((Real)this.real.divide(d), (Real)this.imaginary.divide(d));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Complex other = (Complex)obj;
        return this.real.equals(other.real) && this.imaginary.equals(other.imaginary);
    }

    public Complex logNumeric() {
        if (this.isNaN()) {
            return ComplexNaN;
        }
        double real = this.real.doubleValue();
        double imaginary = this.imaginary.doubleValue();
        return new Complex(FastMath.log((double)Complex.absNumeric(real, imaginary)), FastMath.atan2((double)imaginary, (double)real));
    }

    @Override
    public Complex pow(double exponent) {
        return this.logNumeric().multiply(exponent).expNumeric();
    }

    @Override
    public Complex pow(BigInteger exponent) {
        if (exponent.compareTo(BigInteger.ZERO) < 0) {
            return this.reciprocal().pow(exponent.negate());
        }
        Complex result = ONE;
        Complex k2p = this;
        while (!BigInteger.ZERO.equals(exponent)) {
            if (exponent.testBit(0)) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            exponent = exponent.shiftRight(1);
        }
        return result;
    }

    @Override
    public Complex pow(long exponent) {
        if (exponent < 0L) {
            return this.reciprocal().pow(-exponent);
        }
        Complex result = ONE;
        Complex k2p = this;
        while (exponent != 0L) {
            if (exponent != 0L) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            exponent >>= 1;
        }
        return result;
    }

    @Override
    public Complex pow(int exponent) {
        if (exponent < 0) {
            return this.reciprocal().pow(-exponent);
        }
        Complex result = ONE;
        Complex k2p = this;
        while (exponent != 0) {
            if ((exponent & 1) != 0) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            exponent >>= 1;
        }
        return result;
    }

    public Complex expNumeric() {
        if (this.isNaN()) {
            return ComplexNaN;
        }
        double real = this.real.doubleValue();
        double imaginary = this.imaginary.doubleValue();
        double expReal = FastMath.exp((double)real);
        return new Complex(expReal * FastMath.cos((double)imaginary), expReal * FastMath.sin((double)imaginary));
    }

    public Complex powNumeric(Complex exponent) {
        return this.logNumeric().multiply(exponent).expNumeric();
    }

    @Override
    public boolean isInteger() {
        return this.imaginary.isZero() && this.real.isInteger();
    }

    @Override
    public boolean isNatural() {
        return this.imaginary.isZero() && this.real.isNatural();
    }

    public boolean isNegativeNatural() {
        return this.imaginary.isZero() && this.real.isInteger() && this.real.signum() < 0;
    }

    public boolean isPositiveNatural() {
        return this.imaginary.isZero() && this.real.isInteger() && this.real.signum() >= 0;
    }

    static {
        COMPLEX_INFINITY = COMPLEX_POSITIVE_INFINITY = new Complex(Numeric.POSITIVE_INFINITY, Numeric.POSITIVE_INFINITY);
        ZERO = new Complex(Rational.ZERO, Rational.ZERO);
        ONE = new Complex(Rational.ONE, Rational.ZERO);
        ONE_HALF = new Complex(Rational.ONE_HALF, Rational.ZERO);
        TWO = new Complex(Rational.TWO, Rational.ZERO);
        FOUR = new Complex(Rational.FOUR, Rational.ZERO);
        MINUS_ONE = new Complex(Rational.MINUS_ONE, Rational.ZERO);
        MINUS_ONE_HALF = new Complex(Rational.MINUSE_ONE_HALF, Rational.ZERO);
        MINUS_TWO = new Complex(Rational.MINUS_TWO, Rational.ZERO);
        IMAGINARY_UNIT = new Complex(Rational.ZERO, Rational.ONE);
        NEGATIVE_IMAGINARY_UNIT = new Complex(Rational.ZERO, Rational.MINUS_ONE);
    }

    private static class ComplexBuilder
    implements TensorBuilder {
        private final Complex complex;

        public ComplexBuilder(Complex complex) {
            this.complex = complex;
        }

        @Override
        public Tensor build() {
            return this.complex;
        }

        @Override
        public void put(Tensor tensor) {
            throw new IllegalStateException("Can not put to Complex tensor builder!");
        }

        @Override
        public TensorBuilder clone() {
            return this;
        }
    }
}

