/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.indexmapping.IndexMapping;
import cc.redberry.core.indices.AbstractIndices;
import cc.redberry.core.indices.EmptyIndices;
import cc.redberry.core.indices.InconsistentIndicesException;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.ShortArrayFactory;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import java.lang.ref.WeakReference;
import java.util.Arrays;

final class SortedIndices
extends AbstractIndices {
    private final int firstLower;

    private SortedIndices(int[] data, int firstLower) {
        super(data);
        this.firstLower = firstLower;
    }

    private SortedIndices(int[] data, int firstLower, AbstractIndices.UpperLowerIndices upperLowerIndices) {
        super(data);
        this.firstLower = firstLower;
        this.upperLower = new WeakReference<AbstractIndices.UpperLowerIndices>(upperLowerIndices);
    }

    SortedIndices(int[] data) {
        super(data);
        Arrays.sort(this.data);
        this.firstLower = ArraysUtils.binarySearch1(data, 0);
        this.testConsistentWithException();
    }

    @Override
    public Indices getUpper() {
        AbstractIndices.UpperLowerIndices ul = this.getUpperLowerIndices();
        if (ul.upper.length == 0) {
            return EmptyIndices.EMPTY_INDICES_INSTANCE;
        }
        return new SortedIndices(ul.upper, ul.upper.length, new AbstractIndices.UpperLowerIndices(ul.upper, new int[0]));
    }

    @Override
    public Indices getLower() {
        AbstractIndices.UpperLowerIndices ul = this.getUpperLowerIndices();
        if (ul.lower.length == 0) {
            return EmptyIndices.EMPTY_INDICES_INSTANCE;
        }
        return new SortedIndices(ul.lower, 0, new AbstractIndices.UpperLowerIndices(new int[0], ul.lower));
    }

    @Override
    protected AbstractIndices.UpperLowerIndices calculateUpperLower() {
        int[] upper = Arrays.copyOfRange(this.data, 0, this.firstLower);
        int[] lower = Arrays.copyOfRange(this.data, this.firstLower, this.data.length);
        return new AbstractIndices.UpperLowerIndices(upper, lower);
    }

    @Override
    public int size(IndexType type) {
        int upperPosition;
        byte type_ = type.getType();
        int size = 0;
        int lowerPosition = Arrays.binarySearch(this.data, 0, this.firstLower, type_ << 24 | Integer.MIN_VALUE);
        if (lowerPosition < 0) {
            lowerPosition ^= 0xFFFFFFFF;
        }
        if ((upperPosition = Arrays.binarySearch(this.data, lowerPosition, this.firstLower, type_ + 1 << 24 | Integer.MIN_VALUE)) < 0) {
            upperPosition ^= 0xFFFFFFFF;
        }
        size += upperPosition - lowerPosition;
        lowerPosition = Arrays.binarySearch(this.data, this.firstLower, this.data.length, type_ << 24);
        if (lowerPosition < 0) {
            lowerPosition ^= 0xFFFFFFFF;
        }
        if ((upperPosition = Arrays.binarySearch(this.data, lowerPosition, this.data.length, type_ + 1 << 24)) < 0) {
            upperPosition ^= 0xFFFFFFFF;
        }
        return size += upperPosition - lowerPosition;
    }

    @Override
    public int get(IndexType type, int position) {
        int upperPosition;
        byte type_ = type.getType();
        int lowerPosition = Arrays.binarySearch(this.data, 0, this.firstLower, type_ << 24 | Integer.MIN_VALUE);
        if (lowerPosition < 0) {
            lowerPosition ^= 0xFFFFFFFF;
        }
        if ((upperPosition = Arrays.binarySearch(this.data, lowerPosition, this.firstLower, type_ + 1 << 24 | Integer.MIN_VALUE)) < 0) {
            upperPosition ^= 0xFFFFFFFF;
        }
        if (lowerPosition + position < upperPosition) {
            return this.data[lowerPosition + position];
        }
        position -= upperPosition - lowerPosition;
        lowerPosition = Arrays.binarySearch(this.data, this.firstLower, this.data.length, type_ << 24);
        if (lowerPosition < 0) {
            lowerPosition ^= 0xFFFFFFFF;
        }
        if ((upperPosition = Arrays.binarySearch(this.data, lowerPosition, this.data.length, type_ + 1 << 24)) < 0) {
            upperPosition ^= 0xFFFFFFFF;
        }
        if (lowerPosition + position < upperPosition) {
            return this.data[lowerPosition + position];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Indices getFree() {
        int iUpper;
        IntArrayList list = new IntArrayList();
        int iLower = this.firstLower;
        for (iUpper = 0; iUpper < this.firstLower && iLower < this.data.length; ++iLower, ++iUpper) {
            int u = this.data[iUpper] & Integer.MAX_VALUE;
            int l = this.data[iLower];
            if (u < l) {
                list.add(this.data[iUpper]);
                --iLower;
                continue;
            }
            if (l >= u) continue;
            list.add(l);
            --iUpper;
        }
        list.add(this.data, iUpper, this.firstLower - iUpper);
        list.add(this.data, iLower, this.data.length - iLower);
        return IndicesFactory.create(list.toArray());
    }

    @Override
    public int[] getNamesOfDummies() {
        IntArrayList list = new IntArrayList();
        int iLower = this.firstLower;
        for (int iUpper = 0; iUpper < this.firstLower && iLower < this.data.length; ++iLower, ++iUpper) {
            int u = this.data[iUpper] & Integer.MAX_VALUE;
            int l = this.data[iLower];
            if (u < l) {
                --iLower;
                continue;
            }
            if (l < u) {
                --iUpper;
                continue;
            }
            list.add(l);
        }
        return list.toArray();
    }

    @Override
    public Indices getOfType(IndexType type) {
        int sizeL;
        int upperPositionL;
        int upperPositionU;
        byte type_ = type.getType();
        int lowerPositionU = Arrays.binarySearch(this.data, 0, this.firstLower, type_ << 24 | Integer.MIN_VALUE);
        if (lowerPositionU < 0) {
            lowerPositionU ^= 0xFFFFFFFF;
        }
        if ((upperPositionU = Arrays.binarySearch(this.data, lowerPositionU, this.firstLower, type_ + 1 << 24 | Integer.MIN_VALUE)) < 0) {
            upperPositionU ^= 0xFFFFFFFF;
        }
        int sizeU = upperPositionU - lowerPositionU;
        int lowerPositionL = Arrays.binarySearch(this.data, this.firstLower, this.data.length, type_ << 24);
        if (lowerPositionL < 0) {
            lowerPositionL ^= 0xFFFFFFFF;
        }
        if ((upperPositionL = Arrays.binarySearch(this.data, lowerPositionL, this.data.length, type_ + 1 << 24)) < 0) {
            upperPositionL ^= 0xFFFFFFFF;
        }
        if (sizeU + (sizeL = upperPositionL - lowerPositionL) == this.data.length) {
            return this;
        }
        if (sizeU + sizeL == 0) {
            return IndicesFactory.EMPTY_INDICES;
        }
        int[] indices = new int[sizeU + sizeL];
        System.arraycopy(this.data, lowerPositionU, indices, 0, sizeU);
        System.arraycopy(this.data, lowerPositionL, indices, sizeU, sizeL);
        return new SortedIndices(indices, sizeU);
    }

    @Override
    int[] getSortedData() {
        return this.data;
    }

    @Override
    public Indices getInverted() {
        int i;
        int[] dataInv = new int[this.data.length];
        int fl = this.data.length - this.firstLower;
        for (i = 0; i < this.firstLower; ++i) {
            dataInv[fl + i] = this.data[i] ^ Integer.MIN_VALUE;
        }
        while (i < this.data.length) {
            dataInv[i - this.firstLower] = this.data[i] ^ Integer.MIN_VALUE;
            ++i;
        }
        return new SortedIndices(dataInv, fl);
    }

    @Override
    public void testConsistentWithException() {
        int i;
        for (i = 0; i < this.firstLower - 1; ++i) {
            if (this.data[i] != this.data[i + 1]) continue;
            throw new InconsistentIndicesException(this.data[i]);
        }
        for (i = this.firstLower; i < this.data.length - 1; ++i) {
            if (this.data[i] != this.data[i + 1]) continue;
            throw new InconsistentIndicesException(this.data[i]);
        }
    }

    @Override
    public Indices applyIndexMapping(IndexMapping mapping) {
        boolean changed = false;
        int[] data_ = (int[])this.data.clone();
        for (int i = 0; i < this.data.length; ++i) {
            int newIndex = mapping.map(data_[i]);
            if (data_[i] == newIndex) continue;
            data_[i] = newIndex;
            changed = true;
        }
        if (!changed) {
            return this;
        }
        return new SortedIndices(data_);
    }

    @Override
    public short[] getPositionsInOrbits() {
        return ShortArrayFactory.getZeroFilledShortArray(this.data.length);
    }
}

