/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.PermutationGroup;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.StructureOfIndices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class IndicesSymmetries {
    private final StructureOfIndices structureOfIndices;
    private final List<Permutation> generators;
    private PermutationGroup permutationGroup;
    private short[] positionsInOrbits = null;
    private static IndicesSymmetries EMPTY_INDICES_SYMMETRIES;

    private IndicesSymmetries(StructureOfIndices structureOfIndices) {
        this.structureOfIndices = structureOfIndices;
        this.generators = new ArrayList<Permutation>();
    }

    private IndicesSymmetries(StructureOfIndices structureOfIndices, List<Permutation> generators, PermutationGroup permutationGroup) {
        this.structureOfIndices = structureOfIndices;
        this.generators = generators;
        this.permutationGroup = permutationGroup;
    }

    public static IndicesSymmetries create(StructureOfIndices structureOfIndices) {
        if (structureOfIndices.size() == 0) {
            return IndicesSymmetries.getEmpty();
        }
        return new IndicesSymmetries(structureOfIndices);
    }

    public static IndicesSymmetries create(StructureOfIndices structureOfIndices, PermutationGroup group) {
        if (group.degree() != structureOfIndices.size()) {
            throw new IllegalArgumentException("Degree of permutation group not equal to indices size.");
        }
        if (structureOfIndices.size() == 0) {
            return IndicesSymmetries.getEmpty();
        }
        return new IndicesSymmetries(structureOfIndices, group.generators(), group);
    }

    public static IndicesSymmetries create(StructureOfIndices structureOfIndices, List<Permutation> generators) {
        for (Permutation p : generators) {
            if (p.degree() <= structureOfIndices.size()) continue;
            throw new IllegalArgumentException("Permutation degree not equal to indices size.");
        }
        if (structureOfIndices.size() == 0) {
            return IndicesSymmetries.getEmpty();
        }
        return new IndicesSymmetries(structureOfIndices, new ArrayList<Permutation>(generators), null);
    }

    public StructureOfIndices getStructureOfIndices() {
        return this.structureOfIndices;
    }

    public List<Permutation> getGenerators() {
        return Collections.unmodifiableList(this.generators);
    }

    public PermutationGroup getPermutationGroup() {
        if (this.permutationGroup == null) {
            this.permutationGroup = this.generators.isEmpty() ? PermutationGroup.trivialGroup() : PermutationGroup.createPermutationGroup(this.generators);
        }
        return this.permutationGroup;
    }

    public short[] getPositionsInOrbits() {
        if (this.positionsInOrbits == null) {
            int i;
            int[] positionsInOrbitsInt = this.getPermutationGroup().getPositionsInOrbits();
            this.positionsInOrbits = new short[this.structureOfIndices.size()];
            for (i = 0; i < positionsInOrbitsInt.length; ++i) {
                assert (positionsInOrbitsInt[i] < Short.MAX_VALUE);
                this.positionsInOrbits[i] = (short)positionsInOrbitsInt[i];
            }
            while (i < this.structureOfIndices.size()) {
                this.positionsInOrbits[i] = (short)i;
                ++i;
            }
        }
        return this.positionsInOrbits;
    }

    public final boolean isTrivial() {
        for (Permutation p : this.generators) {
            if (p.isIdentity()) continue;
            return false;
        }
        return true;
    }

    public boolean availableForModification() {
        return this.permutationGroup == null;
    }

    public void addSymmetry(int ... permutation) {
        this.add(false, permutation);
    }

    public void addAntiSymmetry(int ... permutation) {
        this.add(true, permutation);
    }

    public void add(boolean sign, int[] permutation) {
        byte type = -1;
        for (int i = 0; i < 8; ++i) {
            StructureOfIndices.TypeData typeData = this.structureOfIndices.getTypeData((byte)i);
            if (typeData.length == 0) continue;
            if (type != -1) {
                throw new IllegalArgumentException();
            }
            if (typeData.length != permutation.length) {
                throw new IllegalArgumentException();
            }
            type = (byte)i;
        }
        this.addSymmetry(type, Permutations.createPermutation(sign, permutation));
    }

    public void addSymmetry(IndexType type, int ... permutation) {
        this.add(type, false, permutation);
    }

    public void addAntiSymmetry(IndexType type, int ... permutation) {
        this.add(type, true, permutation);
    }

    public void add(IndexType type, boolean sign, int ... permutation) {
        this.addSymmetry(type.getType(), Permutations.createPermutation(sign, permutation));
    }

    public void add(byte type, boolean sign, int ... permutation) {
        this.addSymmetry(type, Permutations.createPermutation(sign, permutation));
    }

    public void addSymmetry(byte type, Permutation symmetry) {
        int i;
        if (this.permutationGroup != null) {
            throw new IllegalStateException("Permutation group is already in use.");
        }
        StructureOfIndices.TypeData data = this.structureOfIndices.getTypeData(type);
        if (data == null) {
            throw new IllegalArgumentException("No such type: " + (Object)((Object)IndexType.getType(type)));
        }
        if (data.length < symmetry.degree()) {
            throw new IllegalArgumentException("Wrong symmetry length.");
        }
        int[] s = new int[this.structureOfIndices.size()];
        for (i = 0; i < data.from; ++i) {
            s[i] = i;
        }
        int j = 0;
        while (j < data.length) {
            s[i] = symmetry.newIndexOf(j) + data.from;
            ++j;
            ++i;
        }
        while (i < this.structureOfIndices.size()) {
            s[i] = i;
            ++i;
        }
        this.generators.add(Permutations.createPermutation(symmetry.antisymmetry(), s));
    }

    public void addSymmetry(Permutation symmetry) {
        if (this.permutationGroup != null) {
            throw new IllegalStateException("Permutation group is already in use.");
        }
        this.generators.add(symmetry);
    }

    public void addSymmetries(Permutation ... symmetries) {
        if (this.permutationGroup != null) {
            throw new IllegalStateException("Permutation group is already in use.");
        }
        for (Permutation symmetry : symmetries) {
            this.generators.add(symmetry);
        }
    }

    public void addSymmetries(Collection<Permutation> symmetries) {
        if (this.permutationGroup != null) {
            throw new IllegalStateException("Permutation group is already in use.");
        }
        for (Permutation symmetry : symmetries) {
            this.generators.add(symmetry);
        }
    }

    public void addAll(Collection<Permutation> symmetry) {
        if (this.permutationGroup != null) {
            throw new IllegalArgumentException();
        }
        this.generators.addAll(symmetry);
    }

    public void setSymmetric() {
        int[] counts;
        if (this.permutationGroup != null) {
            throw new IllegalStateException("Permutation group is already in use.");
        }
        PermutationGroup sym = null;
        for (int c : counts = this.structureOfIndices.getTypesCounts()) {
            if (c == 0) continue;
            sym = sym == null ? PermutationGroup.symmetricGroup(c) : sym.directProduct(PermutationGroup.symmetricGroup(c));
        }
        this.permutationGroup = sym;
        this.generators.clear();
        this.generators.addAll(sym.generators());
    }

    public void setAntiSymmetric() {
        int[] counts;
        if (this.permutationGroup != null) {
            throw new IllegalStateException("Permutation group is already in use.");
        }
        PermutationGroup sym = null;
        for (int c : counts = this.structureOfIndices.getTypesCounts()) {
            if (c == 0) continue;
            sym = sym == null ? PermutationGroup.antisymmetricGroup(c) : sym.directProduct(PermutationGroup.antisymmetricGroup(c));
        }
        this.permutationGroup = sym;
        this.generators.clear();
        this.generators.addAll(sym.generators());
    }

    public IndicesSymmetries clone() {
        if (this.structureOfIndices.size() == 0) {
            return IndicesSymmetries.getEmpty();
        }
        return new IndicesSymmetries(this.structureOfIndices, new ArrayList<Permutation>(this.generators), this.permutationGroup);
    }

    public static IndicesSymmetries getEmpty() {
        if (EMPTY_INDICES_SYMMETRIES == null) {
            EMPTY_INDICES_SYMMETRIES = new IndicesSymmetries(StructureOfIndices.getEmpty(), Collections.EMPTY_LIST, null);
        }
        return EMPTY_INDICES_SYMMETRIES;
    }

    public String toString() {
        return this.generators.toString();
    }
}

