/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.Context;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.EmptyIndices;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.utils.IntArray;
import cc.redberry.core.utils.IntArrayList;
import java.lang.ref.WeakReference;
import java.util.Arrays;

abstract class AbstractIndices
implements Indices {
    final int[] data;
    WeakReference<UpperLowerIndices> upperLower = new WeakReference<Object>(null);

    AbstractIndices(int[] data) {
        this.data = data;
    }

    abstract UpperLowerIndices calculateUpperLower();

    abstract int[] getSortedData();

    UpperLowerIndices getUpperLowerIndices() {
        WeakReference<UpperLowerIndices> wul = this.upperLower;
        UpperLowerIndices ul = (UpperLowerIndices)wul.get();
        if (ul == null) {
            ul = this.calculateUpperLower();
            this.upperLower = new WeakReference<UpperLowerIndices>(ul);
        }
        return ul;
    }

    @Override
    public final int[] toArray() {
        return (int[])this.data.clone();
    }

    @Override
    public final IntArray getAllIndices() {
        return new IntArray(this.data);
    }

    @Override
    public final boolean equalsRegardlessOrder(Indices indices) {
        if (this == indices) {
            return true;
        }
        if (indices instanceof EmptyIndices) {
            return this.data.length == 0;
        }
        return Arrays.equals(this.getSortedData(), ((AbstractIndices)indices).getSortedData());
    }

    @Override
    public final int size() {
        return this.data.length;
    }

    @Override
    public final int get(int position) {
        return this.data[position];
    }

    public final int hashCode() {
        return 291 + Arrays.hashCode(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractIndices)) {
            return false;
        }
        return Arrays.equals(this.data, ((AbstractIndices)obj).data);
    }

    @Override
    public final String toString(OutputFormat format) {
        if (this.data.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (format.is(OutputFormat.WolframMathematica) || format.is(OutputFormat.Maple)) {
            int i = 0;
            while (true) {
                int currentState;
                if ((currentState = this.data[i] >>> 31) == 1) {
                    sb.append(format.upperIndexPrefix);
                } else {
                    sb.append(format.lowerIndexPrefix);
                }
                sb.append(Context.get().getIndexConverterManager().getSymbol(this.data[i], format));
                if (i != this.data.length - 1) {
                    sb.append(",");
                    ++i;
                    continue;
                }
                break;
            }
        } else if (format.is(OutputFormat.Cadabra)) {
            int i;
            IntArrayList nonMetricIndices = new IntArrayList();
            IntArrayList metricIndices = new IntArrayList(this.data.length);
            for (i = 0; i < this.data.length; ++i) {
                if (CC.isMetric(IndicesUtils.getType(this.data[i]))) {
                    metricIndices.add(this.data[i]);
                    continue;
                }
                nonMetricIndices.add(this.data[i]);
            }
            if (!metricIndices.isEmpty()) {
                sb.append("_{");
                i = 0;
                int size = metricIndices.size() - 1;
                while (true) {
                    sb.append(Context.get().getIndexConverterManager().getSymbol(metricIndices.get(i), format));
                    if (i == size) break;
                    sb.append(' ');
                    ++i;
                }
                sb.append('}');
            }
            if (!nonMetricIndices.isEmpty()) {
                int currentState = nonMetricIndices.get(0) >>> 31;
                sb.append(format.lowerIndexPrefix).append('{');
                int lastState = currentState;
                int i2 = 0;
                int size = nonMetricIndices.size() - 1;
                while (true) {
                    if (lastState != (currentState = nonMetricIndices.get(i2) >>> 31)) {
                        sb.append('}').append(format.getPrefixFromIntState(currentState)).append('{');
                        lastState = currentState;
                    }
                    sb.append(Context.get().getIndexConverterManager().getSymbol(nonMetricIndices.get(i2), format));
                    if (i2 == size) break;
                    if (currentState == nonMetricIndices.get(i2 + 1) >>> 31) {
                        sb.append(' ');
                    }
                    ++i2;
                }
                sb.append('}');
            }
        } else {
            String latexBrackets = format.is(OutputFormat.LaTeX) ? "{}" : "";
            int totalToPrint = 0;
            int lastState = -1;
            for (int i = 0; i < this.data.length; ++i) {
                if (!CC.isMetric(IndicesUtils.getType(this.data[i])) && !format.printMatrixIndices) continue;
                int currentState = this.data[i] >>> 31;
                if (lastState != currentState) {
                    if (totalToPrint != 0) {
                        sb.append('}');
                    }
                    sb.append(latexBrackets).append(format.getPrefixFromIntState(currentState)).append('{');
                    lastState = currentState;
                }
                sb.append(Context.get().getIndexConverterManager().getSymbol(this.data[i], format));
                ++totalToPrint;
            }
            sb.append('}');
            if (totalToPrint == 0) {
                return "";
            }
        }
        return sb.toString();
    }

    public final String toString() {
        return this.toString(Context.get().getDefaultOutputFormat());
    }

    static final class UpperLowerIndices {
        final int[] upper;
        final int[] lower;

        UpperLowerIndices(int[] upper, int[] lower) {
            this.upper = upper;
            this.lower = lower;
        }
    }
}

