/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.indexmapping.DummyIndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingBufferRecord;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingProviderAbstractFT;
import cc.redberry.core.indexmapping.IndexMappingProviderFactory;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.OutputPort;
import java.util.Iterator;

final class ProviderSimpleTensor
extends IndexMappingProviderAbstractFT<SimpleTensor> {
    public static final IndexMappingProviderFactory FACTORY_SIMPLETENSOR = new IndexMappingProviderFactory(){

        @Override
        public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
            if (((SimpleTensor)from).getName() != ((SimpleTensor)to).getName()) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            if (from.getIndices().size() == 0) {
                return new DummyIndexMappingProvider(opu);
            }
            return new ProviderSimpleTensor(opu, (SimpleTensor)from, (SimpleTensor)to);
        }
    };
    public static final IndexMappingProviderFactory FACTORY_TENSORFIELD = new IndexMappingProviderFactory(){

        @Override
        public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
            if (((TensorField)from).getName() != ((TensorField)to).getName()) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            for (int i = 0; i < from.size(); ++i) {
                if (IndexMappings.positiveMappingExists(from.get(i), to.get(i))) continue;
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            return new ProviderSimpleTensor(opu, (SimpleTensor)from, (SimpleTensor)to);
        }
    };
    private Iterator<Permutation> searchForPermutations;

    private ProviderSimpleTensor(OutputPort<IndexMappingBuffer> opu, SimpleTensor from, SimpleTensor to) {
        super(opu, from, to);
    }

    @Override
    public IndexMappingBuffer take() {
        if (this.currentBuffer == null) {
            return null;
        }
        SimpleIndices fromIndices = ((SimpleTensor)this.from).getIndices();
        SimpleIndices toIndices = ((SimpleTensor)this.to).getIndices();
        int size = fromIndices.size();
        if (size == 0) {
            IndexMappingBuffer r = this.currentBuffer;
            this.currentBuffer = null;
            return r;
        }
        if (this.searchForPermutations != null) {
            block0: while (this.searchForPermutations.hasNext()) {
                Permutation permutation = this.searchForPermutations.next();
                IndexMappingBuffer tempBuffer = this.currentBuffer.clone();
                for (int i = 0; i < size; ++i) {
                    if (!tempBuffer.tryMap(fromIndices.get(i), toIndices.get(permutation.newIndexOf(i)))) continue block0;
                }
                tempBuffer.addSign(permutation.antisymmetry());
                return tempBuffer;
            }
            this.searchForPermutations = null;
            this.currentBuffer = null;
            return null;
        }
        if (fromIndices.size() == 1 || fromIndices.getSymmetries().isTrivial()) {
            IndexMappingBuffer tempBuffer = this.currentBuffer;
            for (int i = 0; i < size; ++i) {
                if (tempBuffer.tryMap(fromIndices.get(i), toIndices.get(i))) continue;
                this.currentBuffer = null;
                return null;
            }
            this.currentBuffer = null;
            return tempBuffer;
        }
        IntArrayList permMappingFrom = null;
        IntArrayList permMappingTo = null;
        block3: for (int mapFrom = 0; mapFrom < size; ++mapFrom) {
            int fromIndex = fromIndices.get(mapFrom);
            IndexMappingBufferRecord bRec = (IndexMappingBufferRecord)this.currentBuffer.getMap().get(IndicesUtils.getNameWithType(fromIndex));
            if (bRec == null) continue;
            if (IndicesUtils.getRawStateInt(fromIndex) == bRec.getFromRawState()) {
                this.currentBuffer = null;
                return null;
            }
            int toIndex = IndicesUtils.inverseIndexState(IndicesUtils.setRawState(bRec.getToRawState(), bRec.getIndexName()));
            for (int mapTo = 0; mapTo < size; ++mapTo) {
                if (toIndices.get(mapTo) != toIndex) continue;
                if (permMappingFrom == null) {
                    permMappingFrom = new IntArrayList();
                    permMappingTo = new IntArrayList();
                }
                permMappingFrom.add(mapFrom);
                permMappingTo.add(mapTo);
                continue block3;
            }
            this.currentBuffer = null;
            return null;
        }
        this.searchForPermutations = permMappingFrom == null ? fromIndices.getSymmetries().getPermutationGroup().iterator() : new OutputPort.PortIterator<Permutation>(fromIndices.getSymmetries().getPermutationGroup().mapping(permMappingFrom.toArray(), permMappingTo.toArray()));
        return this.take();
    }

    @Override
    protected void _tick() {
        this.searchForPermutations = null;
        this.currentBuffer = null;
    }
}

