/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.indexmapping.DummyIndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingProviderFactory;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.MinusIndexMappingProvider;
import cc.redberry.core.indexmapping.PlusMinusIndexMappingProvider;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.OutputPort;

class ProviderFunctions {
    static final IndexMappingProviderFactory ODD_FACTORY = new IndexMappingProviderFactory(){

        @Override
        public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
            IndexMappingBuffer buffer;
            OutputPort<IndexMappingBuffer> mp = IndexMappings.createPortOfBuffers(from.get(0), to.get(0));
            int state = 0;
            while ((buffer = mp.take()) != null && (state = (int)((byte)(state | (byte)(buffer.getSign() ? 16 : 1)))) != 17) {
            }
            switch (state) {
                case 0: {
                    return IndexMappingProvider.Util.EMPTY_PROVIDER;
                }
                case 1: {
                    return new DummyIndexMappingProvider(opu);
                }
                case 16: {
                    return new MinusIndexMappingProvider(opu);
                }
                case 17: {
                    return new PlusMinusIndexMappingProvider(opu);
                }
            }
            throw new RuntimeException("Ups");
        }
    };
    static final IndexMappingProviderFactory EVEN_FACTORY = new IndexMappingProviderFactory(){

        @Override
        public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
            if (IndexMappings.createPortOfBuffers(from.get(0), to.get(0)).take() != null) {
                return new DummyIndexMappingProvider(opu);
            }
            return IndexMappingProvider.Util.EMPTY_PROVIDER;
        }
    };
    static final IndexMappingProviderFactory FACTORY = new IndexMappingProviderFactory(){

        @Override
        public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
            IndexMappingBuffer buffer = IndexMappings.createPortOfBuffers(from.get(0), to.get(0)).take();
            if (buffer != null && !buffer.getSign()) {
                return new DummyIndexMappingProvider(opu);
            }
            return IndexMappingProvider.Util.EMPTY_PROVIDER;
        }
    };

    ProviderFunctions() {
    }
}

