/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.utils.OutputPort;

interface IndexMappingProvider
extends OutputPort<IndexMappingBuffer> {
    public boolean tick();

    public static class Util {
        public static final IndexMappingProvider EMPTY_PROVIDER = new IndexMappingProvider(){

            @Override
            public boolean tick() {
                return false;
            }

            @Override
            public IndexMappingBuffer take() {
                return null;
            }
        };

        public static IndexMappingProvider singleton(final IndexMappingBuffer buffer) {
            return new IndexMappingProvider(){
                IndexMappingBuffer buf;
                {
                    this.buf = buffer;
                }

                @Override
                public boolean tick() {
                    return false;
                }

                @Override
                public IndexMappingBuffer take() {
                    IndexMappingBuffer tmp = this.buf;
                    this.buf = null;
                    return tmp;
                }
            };
        }
    }
}

