/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexgenerator;

import java.util.Arrays;

public final class IntGenerator {
    private static final int[] EMPTY_ARRAY = new int[]{-1};
    private int[] engagedData;
    private int counter;
    private int match;

    public IntGenerator() {
        this(EMPTY_ARRAY);
    }

    private IntGenerator(int[] engagedData, int counter, int match) {
        this.engagedData = engagedData;
        this.counter = counter;
        this.match = match;
    }

    public IntGenerator(int[] engagedData) {
        this.engagedData = engagedData;
        this.counter = -1;
        this.match = 0;
        Arrays.sort(this.engagedData);
        int shift = 0;
        int i = 0;
        while (i + shift + 1 < engagedData.length) {
            if (engagedData[i + shift] == engagedData[i + shift + 1]) {
                ++shift;
                continue;
            }
            engagedData[i] = engagedData[i + shift];
            ++i;
        }
        engagedData[i] = engagedData[i + shift];
        while (++i < engagedData.length) {
            engagedData[i] = Integer.MAX_VALUE;
        }
    }

    public void mergeFrom(IntGenerator intGenerator) {
        if (intGenerator.engagedData != this.engagedData) {
            throw new IllegalArgumentException();
        }
        if (intGenerator.counter > this.counter) {
            this.counter = intGenerator.counter;
            this.match = intGenerator.match;
        }
    }

    public int getNext() {
        ++this.counter;
        while (this.match < this.engagedData.length && this.engagedData[this.match] == this.counter) {
            ++this.match;
            ++this.counter;
        }
        return this.counter;
    }

    public boolean contains(int index) {
        if (this.counter >= index) {
            return true;
        }
        return Arrays.binarySearch(this.engagedData, this.match, this.engagedData.length, index) >= 0;
    }

    public IntGenerator clone() {
        return new IntGenerator(this.engagedData, this.counter, this.match);
    }
}

